/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.operator;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.helper.PairEntry;
import top.xiajibagao.crane.core.operator.interfaces.Assembler;
import top.xiajibagao.crane.core.parser.EmptyPropertyMapping;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;
import top.xiajibagao.crane.jackson.impl.helper.JacksonUtils;

public class JacksonAssembler
implements Assembler {
    protected final ObjectMapper objectMapper;
    private final OperateHandlerChain handlerChain;

    public void execute(Object target, Object source, AssembleOperation operation) {
        if (JacksonUtils.isNotNodeOrNull(target) || Objects.isNull(source)) {
            return;
        }
        ObjectNode targetNode = (ObjectNode)target;
        JsonNode sourceNode = source instanceof JsonNode ? (JsonNode)source : this.objectMapper.valueToTree(source);
        ((List)CollUtil.defaultIfEmpty((Collection)operation.getProperties(), Collections.singletonList(EmptyPropertyMapping.instance()))).stream().map(property -> PairEntry.of((Object)property, (Object)this.handlerChain.readFromSource((Object)sourceNode, property, (Operation)operation))).filter(PairEntry::hasValue).forEach(pair -> this.handlerChain.writeToTarget(pair.getValue(), (Object)targetNode, (PropertyMapping)pair.getKey(), operation));
    }

    public Object getKey(Object target, AssembleOperation operation) {
        if (!(target instanceof JsonNode)) {
            return null;
        }
        JsonNode targetNode = (JsonNode)target;
        JsonNode keyProperty = this.findKeyNode(targetNode, operation);
        return Objects.isNull(keyProperty) ? null : keyProperty.asText();
    }

    protected JsonNode findKeyNode(JsonNode target, AssembleOperation operation) {
        String keyPropertyName = this.getTranslatedKeyPropertyName(operation);
        JsonNode keyNode = target.get(keyPropertyName);
        if (JacksonUtils.isNotNull(keyNode)) {
            return keyNode;
        }
        return (JsonNode)CollUtil.getFirst(JacksonUtils.findNodes(target, operation.getTargetPropertyAliases()));
    }

    protected String translatePropertyName(String defName) {
        return JacksonUtils.translatePropertyName(this.objectMapper, defName);
    }

    protected String getTranslatedKeyPropertyName(AssembleOperation operation) {
        return this.translatePropertyName(operation.getTargetProperty().getName());
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public OperateHandlerChain getHandlerChain() {
        return this.handlerChain;
    }

    public JacksonAssembler(ObjectMapper objectMapper, OperateHandlerChain handlerChain) {
        this.objectMapper = objectMapper;
        this.handlerChain = handlerChain;
    }
}

