/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.module;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Objects;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.BeanFactoryUtils;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;
import top.xiajibagao.crane.jackson.impl.annotation.ProcessJacksonNode;
import top.xiajibagao.crane.jackson.impl.module.DynamicJsonNodeBeanSerializer;

public class DynamicJsonNodeModule
extends Module {
    private final BeanFactory beanFactory;
    private final ObjectMapper objectMapper;

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        Assert.isFalse((boolean)this.objectMapper.getRegisteredModuleIds().contains(this.getModuleName()), (String)"ObjectMapper\u5b9e\u4f8b{}\u5df2\u7ecf\u6ce8\u518cDynamicJsonNodeModule\u6a21\u5757\uff0c\u8be5\u5b9e\u4f8b\u65e0\u6cd5\u518d\u6ce8\u518c\u81f3\u6a21\u5757\u5185\u90e8", (Object[])new Object[0]);
        context.addBeanSerializerModifier((BeanSerializerModifier)new DynamicJsonNodeBeanSerializerModifier(this.beanFactory, this.objectMapper));
    }

    public DynamicJsonNodeModule(BeanFactory beanFactory, ObjectMapper objectMapper) {
        this.beanFactory = beanFactory;
        this.objectMapper = objectMapper;
    }

    private static class DynamicJsonNodeBeanSerializerModifier
    extends BeanSerializerModifier {
        private final BeanFactory beanFactory;
        private final ObjectMapper objectMapper;

        public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            ProcessJacksonNode annotation = (ProcessJacksonNode)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanDesc.getBeanClass(), ProcessJacksonNode.class);
            if (Objects.isNull(annotation)) {
                return serializer;
            }
            OperateConfigurationParser configurationParser = (OperateConfigurationParser)BeanFactoryUtils.getBean((BeanFactory)this.beanFactory, annotation.parser(), (String)annotation.parserName());
            OperationConfiguration operationConfiguration = configurationParser.parse(beanDesc.getBeanClass());
            OperationExecutor operationExecutor = (OperationExecutor)BeanFactoryUtils.getBean((BeanFactory)this.beanFactory, annotation.executor(), (String)annotation.executorName());
            return new DynamicJsonNodeBeanSerializer(beanDesc.getBeanClass(), this.objectMapper, ArrayUtil.isNotEmpty((Object[])annotation.groups()) ? CollUtil.newHashSet((Object[])annotation.groups()) : Collections.emptySet(), operationConfiguration, operationExecutor);
        }

        public DynamicJsonNodeBeanSerializerModifier(BeanFactory beanFactory, ObjectMapper objectMapper) {
            this.beanFactory = beanFactory;
            this.objectMapper = objectMapper;
        }
    }
}

