/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.handler;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import top.xiajibagao.crane.core.handler.AbstractOperateHandler;
import top.xiajibagao.crane.core.operator.interfaces.OperateProcessor;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.jackson.impl.helper.JacksonUtils;

public abstract class AbstractJacksonNodeOperateHandler
extends AbstractOperateHandler {
    protected final ObjectMapper objectMapper;

    protected AbstractJacksonNodeOperateHandler(ObjectMapper objectMapper, OperateProcessor operateProcessor, String ... defaultRegisterGroups) {
        super(operateProcessor, defaultRegisterGroups);
        this.objectMapper = objectMapper;
    }

    protected JsonNode findNode(JsonNode target, String targetName, Collection<String> aliases) {
        String keyPropertyName = this.translatePropertyName(targetName);
        JsonNode keyNode = target.get(keyPropertyName);
        if (JacksonUtils.isNotNull(keyNode)) {
            return keyNode;
        }
        return (JsonNode)CollUtil.getFirst(JacksonUtils.findNodes(target, aliases));
    }

    protected String findNodeName(JsonNode target, String targetName, Collection<String> aliases) {
        String keyPropertyName = this.translatePropertyName(targetName);
        if (target.has(keyPropertyName)) {
            return targetName;
        }
        if (CollUtil.isEmpty(aliases)) {
            return null;
        }
        return aliases.stream().filter(arg_0 -> ((JsonNode)target).has(arg_0)).findFirst().orElse(null);
    }

    protected String translatePropertyName(String defName) {
        return JacksonUtils.translatePropertyName(this.objectMapper, defName);
    }

    protected String getTranslatedKeyPropertyName(AssembleOperation operation) {
        return this.translatePropertyName(operation.getTargetProperty().getName());
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

