/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.handler;

import cn.hutool.core.text.CharSequenceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import top.xiajibagao.crane.core.annotation.ProcessorComponent;
import top.xiajibagao.crane.core.operator.interfaces.OperateProcessor;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.Operation;
import top.xiajibagao.crane.core.parser.interfaces.PropertyMapping;
import top.xiajibagao.crane.jackson.impl.handler.AbstractJacksonNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.helper.JacksonUtils;

@ProcessorComponent(value={"JSON_BEAN"})
public class ObjectNodeOperateHandler
extends AbstractJacksonNodeOperateHandler {
    public ObjectNodeOperateHandler(ObjectMapper objectMapper, OperateProcessor operateProcessor, String ... defaultRegisterGroups) {
        super(objectMapper, operateProcessor, defaultRegisterGroups);
    }

    public boolean sourceCanRead(Object source, PropertyMapping property, Operation operation) {
        return Objects.nonNull(source);
    }

    public JsonNode readFromSource(Object source, PropertyMapping property, Operation operation) {
        JsonNode sourceNode = JacksonUtils.valueToTree(this.objectMapper, source);
        if (sourceNode.isObject()) {
            return property.hasResource() ? sourceNode.get(this.translatePropertyName(property.getSource())) : sourceNode;
        }
        return property.hasResource() ? NullNode.getInstance() : sourceNode;
    }

    public boolean targetCanWrite(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        return target instanceof ObjectNode;
    }

    public void writeToTarget(Object sourceData, Object target, PropertyMapping property, AssembleOperation operation) {
        ObjectNode targetNode = (ObjectNode)target;
        if (property.hasReference()) {
            String translatedReferenceName = this.translatePropertyName(property.getReference());
            JsonNode sourceNode = JacksonUtils.valueToTree(this.objectMapper, sourceData);
            targetNode.set(translatedReferenceName, sourceNode);
            return;
        }
        String nodeName = this.findNodeName((JsonNode)targetNode, operation.getTargetProperty().getName(), operation.getTargetPropertyAliases());
        if (CharSequenceUtil.isNotBlank((CharSequence)nodeName)) {
            JsonNode sourceNode = JacksonUtils.valueToTree(this.objectMapper, sourceData);
            targetNode.set(nodeName, sourceNode);
        }
    }
}

