/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import top.xiajibagao.crane.jackson.impl.helper.JacksonUtils;

public class JsonNodeAccessor
implements PropertyAccessor {
    private final ObjectMapper objectMapper;

    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{JsonNode.class};
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return JacksonUtils.isNodeAndNotNull(target) && ((JsonNode)target).has(name);
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        return new TypedValue((Object)((JsonNode)target).get(name));
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return target instanceof ObjectNode;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        JsonNode jsonNode = this.objectMapper.valueToTree(newValue);
        ((ObjectNode)target).set(name, jsonNode);
    }

    public JsonNodeAccessor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

