/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.jackson.impl.operator;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import top.xiajibagao.crane.core.operator.interfaces.Disassembler;
import top.xiajibagao.crane.core.operator.interfaces.OperateProcessor;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.jackson.impl.helper.JacksonUtils;

public class JacksonDisassembler
implements Disassembler {
    private final ObjectMapper objectMapper;
    private final OperateProcessor operateProcessor;

    public Collection<?> execute(Object target, DisassembleOperation operation) {
        if (JacksonUtils.isNotNodeOrNull(target)) {
            return Collections.emptyList();
        }
        JsonNode targetNode = JacksonUtils.valueToTree(target);
        JsonNode targetPropertyNode = this.findTargetPropertyNode(targetNode, operation);
        if (JacksonUtils.isNull(targetPropertyNode)) {
            return Collections.emptyList();
        }
        ArrayList<JsonNode> results = new ArrayList<JsonNode>();
        LinkedList<JsonNode> deque = new LinkedList<JsonNode>();
        deque.add(targetPropertyNode);
        while (!deque.isEmpty()) {
            JsonNode node = (JsonNode)deque.removeFirst();
            if (node.isArray()) {
                node.forEach(deque::addLast);
                continue;
            }
            results.add(node);
        }
        return results;
    }

    protected JsonNode findTargetPropertyNode(JsonNode target, DisassembleOperation operation) {
        String keyPropertyName = this.getTranslatedTargetPropertyName(operation);
        JsonNode targetNode = target.get(keyPropertyName);
        if (JacksonUtils.isNotNull(targetNode)) {
            return targetNode;
        }
        return (JsonNode)CollUtil.getFirst(JacksonUtils.findNodes(target, operation.getTargetPropertyAliases()));
    }

    protected String getTranslatedTargetPropertyName(DisassembleOperation operation) {
        return JacksonUtils.translatePropertyName(this.objectMapper, operation.getTargetProperty().getName());
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public OperateProcessor getOperateProcessor() {
        return this.operateProcessor;
    }

    public JacksonDisassembler(ObjectMapper objectMapper, OperateProcessor operateProcessor) {
        this.objectMapper = objectMapper;
        this.operateProcessor = operateProcessor;
    }
}

