/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.starter;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import top.xiajibagao.annotation.MethodSourceBean;
import top.xiajibagao.crane.core.container.EnumDictContainer;
import top.xiajibagao.crane.core.container.KeyValueContainer;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.executor.SequentialOperationExecutor;
import top.xiajibagao.crane.core.executor.UnorderedOperationExecutor;
import top.xiajibagao.crane.core.handler.ArrayOperateHandler;
import top.xiajibagao.crane.core.handler.BeanOperateHandler;
import top.xiajibagao.crane.core.handler.CollectionOperateHandler;
import top.xiajibagao.crane.core.handler.ExpressibleOperateHandlerChain;
import top.xiajibagao.crane.core.handler.MapOperateHandler;
import top.xiajibagao.crane.core.handler.OrderlyOperateHandlerChain;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.helper.EnumDict;
import top.xiajibagao.crane.core.operator.BeanReflexOperatorFactory;
import top.xiajibagao.crane.core.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.core.parser.BeanGlobalConfiguration;
import top.xiajibagao.crane.core.parser.BeanOperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;
import top.xiajibagao.crane.extension.aop.MethodResultProcessAspect;
import top.xiajibagao.crane.extension.cache.ConfigurationCache;
import top.xiajibagao.crane.extension.cache.OperationConfigurationCache;
import top.xiajibagao.crane.extension.container.IntrospectContainer;
import top.xiajibagao.crane.extension.container.MethodSourceContainer;
import top.xiajibagao.crane.extension.helper.OperateHelper;
import top.xiajibagao.crane.jackson.impl.handler.ArrayNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.handler.ObjectNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.handler.ValueNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.module.DynamicJsonNodeModule;
import top.xiajibagao.crane.jackson.impl.operator.JacksonOperatorFactory;

@Configuration
public class CraneAutoConfiguration {

    @AutoConfigureAfter(value={DefaultCraneAutoConfiguration.class})
    @ConditionalOnClass(value={JacksonOperatorFactory.class})
    @Configuration
    public static class DefaultCraneJacksonAutoConfiguration {
        @Order
        @Bean(value={"DefaultCraneJacksonObjectMapper"})
        public ObjectMapper objectMapper() {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return objectMapper;
        }

        @Order
        @ConditionalOnMissingBean(value={OrderlyOperateHandlerChain.class})
        @Bean(value={"DefaultCraneJacksonOrderlyOperateHandlerChain"})
        public OperateHandlerChain orderlyOperateHandlerChain(@Qualifier(value="DefaultCraneJacksonObjectMapper") ObjectMapper objectMapper) {
            OrderlyOperateHandlerChain assembleHandlerChain = new OrderlyOperateHandlerChain();
            assembleHandlerChain.addHandler((OperateHandler)new ArrayNodeOperateHandler(objectMapper, (OperateHandlerChain)assembleHandlerChain)).addHandler((OperateHandler)new ObjectNodeOperateHandler(objectMapper)).addHandler((OperateHandler)new ValueNodeOperateHandler(objectMapper));
            return new ExpressibleOperateHandlerChain((OperateHandlerChain)assembleHandlerChain, StandardEvaluationContext::new);
        }

        @Order
        @ConditionalOnMissingBean(value={BeanReflexOperatorFactory.class})
        @Bean(value={"DefaultCraneJacksonOperatorFactory"})
        public JacksonOperatorFactory jacksonOperatorFactory(@Qualifier(value="DefaultCraneJacksonObjectMapper") ObjectMapper objectMapper, @Qualifier(value="DefaultCraneJacksonOrderlyOperateHandlerChain") OperateHandlerChain assembleHandlerChain) {
            return new JacksonOperatorFactory(objectMapper, assembleHandlerChain);
        }

        @Order
        @Bean(value={"DefaultCraneJacksonDynamicJsonNodeModule"})
        public DynamicJsonNodeModule dynamicJsonNodeModule(BeanFactory beanFactory, @Qualifier(value="DefaultCraneJacksonObjectMapper") ObjectMapper defaultObjectMapper, @Qualifier(value="DefaultCraneJacksonOperatorFactory") OperatorFactory defaultOperatorFactory, @Qualifier(value="DefaultCraneBeanOperateConfigurationParser") OperateConfigurationParser<? extends OperationConfiguration> defaultOperateConfigurationParser, @Qualifier(value="DefaultCraneUnorderedOperationExecutor") OperationExecutor defaultOperationExecutor) {
            return new DynamicJsonNodeModule(beanFactory, defaultObjectMapper, defaultOperatorFactory, defaultOperateConfigurationParser, defaultOperationExecutor);
        }

        @Order
        @Bean(value={"DefaultCraneJacksonSerializeObjectMapper"})
        public ObjectMapper serializeObjectMapper(@Qualifier(value="DefaultCraneJacksonDynamicJsonNodeModule") DynamicJsonNodeModule dynamicJsonNodeModule) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)dynamicJsonNodeModule);
            return objectMapper;
        }
    }

    @AutoConfigureAfter(value={DefaultCraneAutoConfiguration.class})
    @Configuration
    public static class DefaultCraneExtensionAutoConfiguration {
        @Order
        @ConditionalOnMissingBean(value={MethodSourceContainer.class})
        @Bean(value={"DefaultCraneMethodSourceContainer"})
        public MethodSourceContainer methodSourceContainer(ApplicationContext applicationContext) {
            MethodSourceContainer container = new MethodSourceContainer();
            Map beans = applicationContext.getBeansWithAnnotation(MethodSourceBean.class);
            if (CollUtil.isNotEmpty((Map)beans)) {
                beans.forEach((name, bean) -> container.register(bean));
            }
            return container;
        }

        @Order
        @ConditionalOnMissingBean(value={MethodSourceContainer.class})
        @Bean(value={"DefaultCraneIntrospectContainer"})
        public IntrospectContainer introspectContainer() {
            return new IntrospectContainer();
        }

        @Order
        @ConditionalOnMissingBean(value={OperationConfigurationCache.class})
        @Bean(value={"DefaultCraneOperationConfigurationCache"})
        public OperationConfigurationCache operationConfigurationCache() {
            return new OperationConfigurationCache();
        }

        @Order
        @ConditionalOnMissingBean(value={MethodResultProcessAspect.class})
        @Bean(value={"DefaultCraneMethodResultProcessAspect"})
        public MethodResultProcessAspect methodResultProcessAspect(BeanFactory beanFactory, @Qualifier(value="DefaultCraneOperationConfigurationCache") ConfigurationCache configurationCache) {
            return new MethodResultProcessAspect(beanFactory, configurationCache);
        }

        @Order
        @ConditionalOnMissingBean(value={OperateHelper.class})
        @Bean(value={"DefaultCraneOperateHelper"})
        public OperateHelper operateHelper(@Qualifier(value="DefaultCraneOperationConfigurationCache") ConfigurationCache configurationCache, @Qualifier(value="DefaultCraneBeanReflexOperatorFactory") OperatorFactory defaultOperatorFactory, @Qualifier(value="DefaultCraneBeanOperateConfigurationParser") OperateConfigurationParser<? extends OperationConfiguration> defaultOperateConfigurationParser, @Qualifier(value="DefaultCraneUnorderedOperationExecutor") OperationExecutor defaultOperationExecutor) {
            return new OperateHelper(configurationCache, defaultOperatorFactory, defaultOperateConfigurationParser, defaultOperationExecutor);
        }
    }

    @Configuration
    public static class DefaultCraneAutoConfiguration {
        @Order
        @ConditionalOnMissingBean(value={GlobalConfiguration.class})
        @Bean(value={"DefaultCraneGlobalConfiguration"})
        public GlobalConfiguration globalConfiguration() {
            return new BeanGlobalConfiguration();
        }

        @Order
        @ConditionalOnMissingBean(value={BeanOperateConfigurationParser.class})
        @Bean(value={"DefaultCraneBeanOperateConfigurationParser"})
        public BeanOperateConfigurationParser beanOperateConfigurationParser(GlobalConfiguration configuration, BeanFactory beanFactory) {
            return new BeanOperateConfigurationParser(configuration, beanFactory);
        }

        @Order
        @ConditionalOnMissingBean(value={OrderlyOperateHandlerChain.class})
        @Bean(value={"DefaultCraneOrderlyOperateHandlerChain"})
        public OperateHandlerChain orderlyOperateHandlerChain() {
            OrderlyOperateHandlerChain operateHandlerChain = new OrderlyOperateHandlerChain();
            operateHandlerChain.addHandler((OperateHandler)new MapOperateHandler()).addHandler((OperateHandler)new CollectionOperateHandler((OperateHandlerChain)operateHandlerChain)).addHandler((OperateHandler)new ArrayOperateHandler((OperateHandlerChain)operateHandlerChain)).addHandler((OperateHandler)new MapOperateHandler()).addHandler((OperateHandler)new BeanOperateHandler());
            return new ExpressibleOperateHandlerChain((OperateHandlerChain)operateHandlerChain, StandardEvaluationContext::new);
        }

        @Order
        @ConditionalOnMissingBean(value={BeanReflexOperatorFactory.class})
        @Bean(value={"DefaultCraneBeanReflexOperatorFactory"})
        public BeanReflexOperatorFactory reflexOperatorFactory(@Qualifier(value="DefaultCraneOrderlyOperateHandlerChain") OperateHandlerChain assembleHandlerChain) {
            return new BeanReflexOperatorFactory(assembleHandlerChain);
        }

        @Order
        @ConditionalOnMissingBean(value={EnumDict.class})
        @Bean(value={"DefaultCraneEnumDict"})
        public EnumDict enumDict() {
            return EnumDict.instance();
        }

        @Order
        @ConditionalOnMissingBean(value={EnumDictContainer.class})
        @Bean(value={"DefaultCraneEnumDictContainer"})
        public EnumDictContainer enumDictContainer(EnumDict enumDict) {
            return new EnumDictContainer(enumDict);
        }

        @Order
        @ConditionalOnMissingBean(value={KeyValueContainer.class})
        @Bean(value={"DefaultCraneKeyValueContainer"})
        public KeyValueContainer simpleKeyValueActuator() {
            return new KeyValueContainer();
        }

        @Order
        @ConditionalOnMissingBean(value={UnorderedOperationExecutor.class})
        @Bean(value={"DefaultCraneUnorderedOperationExecutor"})
        public UnorderedOperationExecutor unorderedOperationExecutor() {
            return new UnorderedOperationExecutor();
        }

        @Order
        @ConditionalOnMissingBean(value={SequentialOperationExecutor.class})
        @Bean(value={"DefaultCraneSequentialOperationExecutor"})
        public SequentialOperationExecutor operationExecutor() {
            return new SequentialOperationExecutor();
        }
    }
}

