/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.starter;

import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import top.xiajibagao.crane.core.annotation.MethodSourceBean;
import top.xiajibagao.crane.core.aop.MethodResultProcessAspect;
import top.xiajibagao.crane.core.cache.ConfigurationCache;
import top.xiajibagao.crane.core.cache.OperationConfigurationCache;
import top.xiajibagao.crane.core.container.BeanIntrospectContainer;
import top.xiajibagao.crane.core.container.EnumDictContainer;
import top.xiajibagao.crane.core.container.KeyIntrospectContainer;
import top.xiajibagao.crane.core.container.KeyValueContainer;
import top.xiajibagao.crane.core.container.MethodSourceContainer;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.executor.SequentialOperationExecutor;
import top.xiajibagao.crane.core.executor.UnorderedOperationExecutor;
import top.xiajibagao.crane.core.handler.ArrayOperateHandler;
import top.xiajibagao.crane.core.handler.BeanOperateHandler;
import top.xiajibagao.crane.core.handler.CollectionOperateHandler;
import top.xiajibagao.crane.core.handler.ExpressibleOperateHandlerChain;
import top.xiajibagao.crane.core.handler.MapOperateHandler;
import top.xiajibagao.crane.core.handler.OrderlyOperateHandlerChain;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.helper.EnumDict;
import top.xiajibagao.crane.core.helper.OperateTemplate;
import top.xiajibagao.crane.core.operator.BeanReflexAssembler;
import top.xiajibagao.crane.core.operator.BeanReflexDisassembler;
import top.xiajibagao.crane.core.parser.BeanGlobalConfiguration;
import top.xiajibagao.crane.core.parser.ClassAnnotationConfigurationParser;
import top.xiajibagao.crane.core.parser.CombineOperationConfigurationParser;
import top.xiajibagao.crane.core.parser.FieldAnnotationConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.starter.CraneAutoConfigurationProperties;

@AutoConfigureAfter(value={CraneAutoConfigurationProperties.class})
@Configuration
public class CraneAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CraneAutoConfiguration.class);

    @Order
    @ConditionalOnMissingBean(value={GlobalConfiguration.class})
    @Bean(value={"CraneDefaultGlobalConfiguration"})
    public GlobalConfiguration globalConfiguration(CraneAutoConfigurationProperties craneAutoConfigurationProperties) {
        return new BeanGlobalConfiguration();
    }

    @Order
    @ConditionalOnMissingBean(value={FieldAnnotationConfigurationParser.class})
    @Bean(value={"DefaultCraneFieldAnnotationConfigurationParser"})
    public FieldAnnotationConfigurationParser fieldAnnotationConfigurationParser(GlobalConfiguration configuration, BeanFactory beanFactory) {
        return new FieldAnnotationConfigurationParser(configuration, beanFactory);
    }

    @Order
    @ConditionalOnMissingBean(value={ClassAnnotationConfigurationParser.class})
    @Bean(value={"DefaultCraneClassAnnotationConfigurationParser"})
    public ClassAnnotationConfigurationParser classAnnotationConfigurationParser(GlobalConfiguration configuration, BeanFactory beanFactory) {
        return new ClassAnnotationConfigurationParser(configuration, beanFactory);
    }

    @Order
    @ConditionalOnMissingBean(value={CombineOperationConfigurationParser.class})
    @Bean(value={"DefaultCraneCombineOperationConfigurationParser"})
    public CombineOperationConfigurationParser classAnnotationConfigurationParser(Collection<OperateConfigurationParser> parsers) {
        CombineOperationConfigurationParser parser = new CombineOperationConfigurationParser();
        parsers.forEach(arg_0 -> ((CombineOperationConfigurationParser)parser).addParser(arg_0));
        return parser;
    }

    @Order
    @ConditionalOnMissingBean(value={OrderlyOperateHandlerChain.class})
    @Bean(value={"DefaultCraneOrderlyOperateHandlerChain"})
    public OperateHandlerChain orderlyOperateHandlerChain() {
        OrderlyOperateHandlerChain operateHandlerChain = new OrderlyOperateHandlerChain();
        operateHandlerChain.addHandler((OperateHandler)new MapOperateHandler()).addHandler((OperateHandler)new CollectionOperateHandler((OperateHandlerChain)operateHandlerChain)).addHandler((OperateHandler)new ArrayOperateHandler((OperateHandlerChain)operateHandlerChain)).addHandler((OperateHandler)new MapOperateHandler()).addHandler((OperateHandler)new BeanOperateHandler());
        log.info("\u6ce8\u518c\u5904\u7406\u5668\u94fe {}, \u5df2\u914d\u7f6e\u8282\u70b9: {}", (Object)"DefaultCraneOrderlyOperateHandlerChain", (Object)CollUtil.join((Iterable)operateHandlerChain.handlers(), (CharSequence)", ", h -> h.getClass().getName()));
        return new ExpressibleOperateHandlerChain((OperateHandlerChain)operateHandlerChain, StandardEvaluationContext::new);
    }

    @Order
    @ConditionalOnMissingBean(value={BeanReflexAssembler.class})
    @Bean(value={"DefaultCraneBeanReflexAssembler"})
    public BeanReflexAssembler beanReflexAssembler(@Qualifier(value="DefaultCraneOrderlyOperateHandlerChain") OperateHandlerChain assembleHandlerChain) {
        return new BeanReflexAssembler(assembleHandlerChain);
    }

    @Order
    @ConditionalOnMissingBean(value={BeanReflexDisassembler.class})
    @Bean(value={"DefaultCraneBeanReflexDisassembler"})
    public BeanReflexDisassembler beanReflexDisassembler(@Qualifier(value="DefaultCraneOrderlyOperateHandlerChain") OperateHandlerChain assembleHandlerChain) {
        return new BeanReflexDisassembler(assembleHandlerChain);
    }

    @Order
    @ConditionalOnMissingBean(value={EnumDict.class})
    @Bean(value={"DefaultCraneEnumDict"})
    public EnumDict enumDict() {
        return EnumDict.instance();
    }

    @Order
    @ConditionalOnMissingBean(value={EnumDictContainer.class})
    @Bean(value={"DefaultCraneEnumDictContainer"})
    public EnumDictContainer enumDictContainer(EnumDict enumDict) {
        this.logContainerRegistered(EnumDictContainer.class);
        return new EnumDictContainer(enumDict);
    }

    @Order
    @ConditionalOnMissingBean(value={KeyValueContainer.class})
    @Bean(value={"DefaultCraneKeyValueContainer"})
    public KeyValueContainer simpleKeyValueContainer() {
        this.logContainerRegistered(KeyValueContainer.class);
        return new KeyValueContainer();
    }

    @Order
    @ConditionalOnMissingBean(value={MethodSourceContainer.class})
    @Bean(value={"DefaultCraneMethodSourceContainer"})
    public MethodSourceContainer methodSourceContainer(ApplicationContext applicationContext) {
        this.logContainerRegistered(MethodSourceContainer.class);
        MethodSourceContainer container = new MethodSourceContainer();
        Map beans = applicationContext.getBeansWithAnnotation(MethodSourceBean.class);
        if (CollUtil.isNotEmpty((Map)beans)) {
            beans.forEach((name, bean) -> container.register(bean));
        }
        return container;
    }

    @Order
    @ConditionalOnMissingBean(value={BeanIntrospectContainer.class})
    @Bean(value={"DefaultCraneBeanIntrospectContainer"})
    public BeanIntrospectContainer introspectContainer() {
        this.logContainerRegistered(BeanIntrospectContainer.class);
        return new BeanIntrospectContainer();
    }

    @Order
    @ConditionalOnMissingBean(value={KeyIntrospectContainer.class})
    @Bean(value={"DefaultCraneKeyIntrospectContainer"})
    public KeyIntrospectContainer keyIntrospectContainer() {
        this.logContainerRegistered(KeyIntrospectContainer.class);
        return new KeyIntrospectContainer();
    }

    @Order
    @ConditionalOnMissingBean(value={UnorderedOperationExecutor.class})
    @Bean(value={"DefaultCraneUnorderedOperationExecutor"})
    public UnorderedOperationExecutor unorderedOperationExecutor() {
        return new UnorderedOperationExecutor();
    }

    @Order
    @ConditionalOnMissingBean(value={SequentialOperationExecutor.class})
    @Bean(value={"DefaultCraneSequentialOperationExecutor"})
    public SequentialOperationExecutor operationExecutor() {
        return new SequentialOperationExecutor();
    }

    @Order
    @ConditionalOnMissingBean(value={OperationConfigurationCache.class})
    @Bean(value={"DefaultCraneOperationConfigurationCache"})
    public OperationConfigurationCache operationConfigurationCache() {
        return new OperationConfigurationCache();
    }

    @Order
    @ConditionalOnMissingBean(value={MethodResultProcessAspect.class})
    @Bean(value={"DefaultCraneMethodResultProcessAspect"})
    public MethodResultProcessAspect methodResultProcessAspect(BeanFactory beanFactory, @Qualifier(value="DefaultCraneOperationConfigurationCache") ConfigurationCache configurationCache) {
        log.info("\u542f\u7528\u5207\u9762\uff1a{}", MethodResultProcessAspect.class);
        return new MethodResultProcessAspect(beanFactory, configurationCache);
    }

    @Order
    @ConditionalOnMissingBean(value={OperateTemplate.class})
    @Bean(value={"DefaultCraneOperateTemplate"})
    public OperateTemplate operateTemplate(@Qualifier(value="DefaultCraneOperationConfigurationCache") ConfigurationCache configurationCache, @Qualifier(value="DefaultCraneFieldAnnotationConfigurationParser") OperateConfigurationParser defaultOperateConfigurationParser, @Qualifier(value="DefaultCraneUnorderedOperationExecutor") OperationExecutor defaultOperationExecutor) {
        return new OperateTemplate(configurationCache, defaultOperateConfigurationParser, defaultOperationExecutor);
    }

    private void logContainerRegistered(Class<?> containerClass) {
        log.info("\u6ce8\u518c\u5bb9\u5668\uff1a{}", containerClass);
    }
}

