/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.starter;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import top.xiajibagao.crane.core.handler.ExpressibleOperateHandlerChain;
import top.xiajibagao.crane.core.handler.OrderlyOperateHandlerChain;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.jackson.impl.handler.ArrayNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.handler.ObjectNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.handler.ValueNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.module.DynamicJsonNodeModule;
import top.xiajibagao.crane.jackson.impl.operator.JacksonAssembler;
import top.xiajibagao.crane.jackson.impl.operator.JacksonDisassembler;
import top.xiajibagao.crane.starter.CraneAutoConfiguration;

@AutoConfigureAfter(value={CraneAutoConfiguration.class})
@ConditionalOnClass(value={JacksonAssembler.class, JacksonDisassembler.class})
@Configuration
public class CraneJacksonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CraneJacksonAutoConfiguration.class);
    public static final String CRANE_INNER_OBJECT_MAPPER = "CraneInnerObjectMapper";

    @Order
    @ConditionalOnMissingBean(value={ObjectMapper.class}, name={"CraneInnerObjectMapper"})
    @Bean(value={"CraneInnerObjectMapper"})
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper;
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @ConditionalOnMissingBean(value={OrderlyOperateHandlerChain.class})
    @Bean(value={"DefaultCraneJacksonOrderlyOperateHandlerChain"})
    public OperateHandlerChain orderlyOperateHandlerChain(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper) {
        OrderlyOperateHandlerChain operateHandlerChain = new OrderlyOperateHandlerChain();
        operateHandlerChain.addHandler((OperateHandler)new ArrayNodeOperateHandler(objectMapper, (OperateHandlerChain)operateHandlerChain)).addHandler((OperateHandler)new ObjectNodeOperateHandler(objectMapper)).addHandler((OperateHandler)new ValueNodeOperateHandler(objectMapper));
        log.info("\u6ce8\u518c\u5904\u7406\u5668\u94fe {}, \u5df2\u914d\u7f6e\u8282\u70b9: {}", (Object)"DefaultCraneJacksonOrderlyOperateHandlerChain", (Object)CollUtil.join((Iterable)operateHandlerChain.handlers(), (CharSequence)", ", h -> h.getClass().getName()));
        return new ExpressibleOperateHandlerChain((OperateHandlerChain)operateHandlerChain, StandardEvaluationContext::new);
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @ConditionalOnMissingBean(value={JacksonAssembler.class})
    @Bean(value={"DefaultCraneJacksonAssembler"})
    public JacksonAssembler jacksonAssembler(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper, @Qualifier(value="DefaultCraneJacksonOrderlyOperateHandlerChain") OperateHandlerChain assembleHandlerChain) {
        return new JacksonAssembler(objectMapper, assembleHandlerChain);
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @ConditionalOnMissingBean(value={JacksonDisassembler.class})
    @Bean(value={"DefaultCraneJacksonDisassembler"})
    public JacksonDisassembler jacksonDisassembler(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper) {
        return new JacksonDisassembler(objectMapper);
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @Bean(value={"DefaultCraneJacksonDynamicJsonNodeModule"})
    public DynamicJsonNodeModule dynamicJsonNodeModule(BeanFactory beanFactory, @Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper) {
        return new DynamicJsonNodeModule(beanFactory, objectMapper);
    }
}

