/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.starter;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.expression.PropertyAccessor;
import top.xiajibagao.crane.core.handler.ExpressionPreprocessingInterceptor;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.handler.interfaces.SourceOperateInterceptor;
import top.xiajibagao.crane.jackson.impl.handler.ArrayNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.handler.JacksonOperateHandlerChain;
import top.xiajibagao.crane.jackson.impl.handler.NullNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.handler.ObjectNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.handler.ValueNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.helper.JsonNodeAccessor;
import top.xiajibagao.crane.jackson.impl.module.DynamicJsonNodeModule;
import top.xiajibagao.crane.jackson.impl.operator.JacksonAssembler;
import top.xiajibagao.crane.jackson.impl.operator.JacksonDisassembler;
import top.xiajibagao.crane.starter.CraneAutoConfiguration;

@AutoConfigureAfter(value={CraneAutoConfiguration.class})
@ConditionalOnClass(value={JacksonAssembler.class, JacksonDisassembler.class})
@Configuration
public class CraneJacksonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CraneJacksonAutoConfiguration.class);
    public static final String CRANE_INNER_OBJECT_MAPPER = "CraneInnerObjectMapper";

    @Order
    @ConditionalOnMissingBean(value={ObjectMapper.class}, name={"CraneInnerObjectMapper"})
    @Bean(value={"CraneInnerObjectMapper"})
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper;
    }

    @Order
    @ConditionalOnMissingBean(value={ExpressionPreprocessingInterceptor.ContextFactory.class})
    @Bean(value={"DefaultCraneExpressionPreprocessingInterceptorContextFactory"})
    public ExpressionPreprocessingInterceptor.ContextFactory expressionContextFactory(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper) {
        return new ExpressionPreprocessingInterceptor.DefaultContextFactory().addAction(context -> context.addPropertyAccessor((PropertyAccessor)new JsonNodeAccessor(objectMapper)));
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @ConditionalOnMissingBean(value={JacksonOperateHandlerChain.class})
    @Bean(value={"DefaultCraneJacksonOperateHandlerChain"})
    public JacksonOperateHandlerChain jacksonOperateHandlerChain(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper, List<SourceOperateInterceptor> interceptors) {
        JacksonOperateHandlerChain operateHandlerChain = new JacksonOperateHandlerChain();
        interceptors.forEach(arg_0 -> ((JacksonOperateHandlerChain)operateHandlerChain).addInterceptor(arg_0));
        operateHandlerChain.addHandler((OperateHandler)new ArrayNodeOperateHandler(objectMapper, (OperateHandlerChain)operateHandlerChain)).addHandler((OperateHandler)new NullNodeOperateHandler()).addHandler((OperateHandler)new ObjectNodeOperateHandler(objectMapper)).addHandler((OperateHandler)new ValueNodeOperateHandler(objectMapper));
        log.info("\u6ce8\u518c\u5904\u7406\u5668\u94fe {}, \u5df2\u914d\u7f6e\u8282\u70b9: {}", (Object)"DefaultCraneJacksonOrderlyOperateHandlerChain", (Object)CollUtil.join((Iterable)operateHandlerChain.handlers(), (CharSequence)", ", h -> h.getClass().getName()));
        return operateHandlerChain;
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @ConditionalOnMissingBean(value={JacksonAssembler.class})
    @Bean(value={"DefaultCraneJacksonAssembler"})
    public JacksonAssembler jacksonAssembler(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper, JacksonOperateHandlerChain operateHandlerChain) {
        return new JacksonAssembler(objectMapper, (OperateHandlerChain)operateHandlerChain);
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @ConditionalOnMissingBean(value={JacksonDisassembler.class})
    @Bean(value={"DefaultCraneJacksonDisassembler"})
    public JacksonDisassembler jacksonDisassembler(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper) {
        return new JacksonDisassembler(objectMapper);
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @Bean(value={"DefaultCraneJacksonDynamicJsonNodeModule"})
    public DynamicJsonNodeModule dynamicJsonNodeModule(BeanFactory beanFactory, @Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper) {
        return new DynamicJsonNodeModule(beanFactory, objectMapper);
    }
}

