/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.starter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.expression.PropertyAccessor;
import org.springframework.stereotype.Component;
import top.xiajibagao.crane.core.interceptor.ExpressionPreprocessingInterceptor;
import top.xiajibagao.crane.core.operator.interfaces.OperateProcessor;
import top.xiajibagao.crane.jackson.impl.handler.ArrayNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.handler.NullNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.handler.ObjectNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.handler.ValueNodeOperateHandler;
import top.xiajibagao.crane.jackson.impl.helper.JsonNodeAccessor;
import top.xiajibagao.crane.jackson.impl.module.DynamicJsonNodeModule;
import top.xiajibagao.crane.jackson.impl.operator.JacksonAssembler;
import top.xiajibagao.crane.jackson.impl.operator.JacksonDisassembler;
import top.xiajibagao.crane.jackson.impl.operator.JacksonOperateProcessor;
import top.xiajibagao.crane.starter.ConfigHelper;
import top.xiajibagao.crane.starter.CraneAutoConfiguration;

@AutoConfigureAfter(value={CraneAutoConfiguration.class})
@ConditionalOnClass(value={JacksonAssembler.class, JacksonDisassembler.class})
@Configuration
public class CraneJacksonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CraneJacksonAutoConfiguration.class);
    public static final String CRANE_INNER_OBJECT_MAPPER = "CraneInnerObjectMapper";

    @Order
    @ConditionalOnMissingBean(value={ObjectMapper.class}, name={"CraneInnerObjectMapper"})
    @Bean(value={"CraneInnerObjectMapper"})
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper;
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @ConditionalOnMissingBean(value={JacksonOperateProcessor.class})
    @Bean(value={"DefaultCraneJacksonOperateProcessor"})
    public JacksonOperateProcessor jacksonOperateProcessor() {
        return new JacksonOperateProcessor();
    }

    @ConditionalOnMissingBean(value={ValueNodeOperateHandler.class})
    @Bean(value={"DefaultCraneValueNodeOperateHandler"})
    public ValueNodeOperateHandler valueNodeOperateHandler(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper, JacksonOperateProcessor jacksonOperateProcessor) {
        return new ValueNodeOperateHandler(objectMapper, (OperateProcessor)jacksonOperateProcessor, new String[0]);
    }

    @ConditionalOnMissingBean(value={ObjectNodeOperateHandler.class})
    @Bean(value={"DefaultCraneObjectNodeOperateHandler"})
    public ObjectNodeOperateHandler objectNodeOperateHandler(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper, JacksonOperateProcessor jacksonOperateProcessor) {
        return new ObjectNodeOperateHandler(objectMapper, (OperateProcessor)jacksonOperateProcessor, new String[0]);
    }

    @ConditionalOnMissingBean(value={NullNodeOperateHandler.class})
    @Bean(value={"DefaultCraneNullNodeOperateHandler"})
    public NullNodeOperateHandler nullNodeOperateHandler(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper, JacksonOperateProcessor jacksonOperateProcessor) {
        return new NullNodeOperateHandler(objectMapper, (OperateProcessor)jacksonOperateProcessor, new String[0]);
    }

    @ConditionalOnMissingBean(value={ArrayNodeOperateHandler.class})
    @Bean(value={"DefaultCraneArrayNodeOperateHandler"})
    public ArrayNodeOperateHandler arrayNodeOperateHandler(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper, JacksonOperateProcessor jacksonOperateProcessor) {
        return new ArrayNodeOperateHandler(objectMapper, (OperateProcessor)jacksonOperateProcessor, new String[0]);
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @ConditionalOnMissingBean(value={JacksonAssembler.class})
    @Bean(value={"DefaultCraneJacksonAssembler"})
    public JacksonAssembler jacksonAssembler(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper, JacksonOperateProcessor jacksonOperateProcessor) {
        return new JacksonAssembler(objectMapper, (OperateProcessor)jacksonOperateProcessor);
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @ConditionalOnMissingBean(value={JacksonDisassembler.class})
    @Bean(value={"DefaultCraneJacksonDisassembler"})
    public JacksonDisassembler jacksonDisassembler(@Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper, JacksonOperateProcessor jacksonOperateProcessor) {
        return new JacksonDisassembler(objectMapper, (OperateProcessor)jacksonOperateProcessor);
    }

    @Order
    @ConditionalOnBean(name={"CraneInnerObjectMapper"})
    @Bean(value={"DefaultCraneJacksonDynamicJsonNodeModule"})
    public DynamicJsonNodeModule dynamicJsonNodeModule(BeanFactory beanFactory, @Qualifier(value="CraneInnerObjectMapper") ObjectMapper objectMapper) {
        return new DynamicJsonNodeModule(beanFactory, objectMapper);
    }

    @Component
    public static class AfterJacksonConfigurationInitedRunner
    implements ApplicationRunner {
        private final JacksonOperateProcessor jacksonOperateProcessor;
        private final ExpressionPreprocessingInterceptor expressionPreprocessingInterceptor;
        private final ApplicationContext applicationContext;
        @Qualifier(value="CraneInnerObjectMapper")
        private final ObjectMapper objectMapper;

        public void run(ApplicationArguments args) {
            this.initOperateProcessor();
            this.initContextFactoryFactory();
        }

        public void initContextFactoryFactory() {
            ExpressionPreprocessingInterceptor.ContextFactory contextFactory = this.expressionPreprocessingInterceptor.getContextFactory();
            if (contextFactory instanceof ExpressionPreprocessingInterceptor.DefaultContextFactory) {
                ((ExpressionPreprocessingInterceptor.DefaultContextFactory)contextFactory).addAction(context -> context.addPropertyAccessor((PropertyAccessor)new JsonNodeAccessor(this.objectMapper)));
            }
        }

        private void initOperateProcessor() {
            ConfigHelper.registerForOperateProcessor((OperateProcessor)this.jacksonOperateProcessor, (ListableBeanFactory)this.applicationContext);
        }

        public AfterJacksonConfigurationInitedRunner(JacksonOperateProcessor jacksonOperateProcessor, ExpressionPreprocessingInterceptor expressionPreprocessingInterceptor, ApplicationContext applicationContext, ObjectMapper objectMapper) {
            this.jacksonOperateProcessor = jacksonOperateProcessor;
            this.expressionPreprocessingInterceptor = expressionPreprocessingInterceptor;
            this.applicationContext = applicationContext;
            this.objectMapper = objectMapper;
        }
    }
}

