/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.starter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ClassUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import top.xiajibagao.crane.core.annotation.MethodSourceBean;
import top.xiajibagao.crane.core.aop.MethodResultProcessAspect;
import top.xiajibagao.crane.core.cache.ConfigurationCache;
import top.xiajibagao.crane.core.cache.OperationConfigurationCache;
import top.xiajibagao.crane.core.container.BeanIntrospectContainer;
import top.xiajibagao.crane.core.container.EnumDictContainer;
import top.xiajibagao.crane.core.container.KeyIntrospectContainer;
import top.xiajibagao.crane.core.container.KeyValueContainer;
import top.xiajibagao.crane.core.container.MethodSourceContainer;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.executor.SequentialOperationExecutor;
import top.xiajibagao.crane.core.executor.UnorderedOperationExecutor;
import top.xiajibagao.crane.core.handler.ArrayOperateHandler;
import top.xiajibagao.crane.core.handler.BeanOperateHandler;
import top.xiajibagao.crane.core.handler.CollectionOperateHandler;
import top.xiajibagao.crane.core.handler.MapOperateHandler;
import top.xiajibagao.crane.core.handler.NullOperateHandler;
import top.xiajibagao.crane.core.helper.EnumDict;
import top.xiajibagao.crane.core.helper.OperateTemplate;
import top.xiajibagao.crane.core.helper.property.AsmReflexBeanPropertyFactory;
import top.xiajibagao.crane.core.helper.property.BeanPropertyFactory;
import top.xiajibagao.crane.core.helper.property.ReflexBeanPropertyFactory;
import top.xiajibagao.crane.core.interceptor.ExpressionPreprocessingInterceptor;
import top.xiajibagao.crane.core.operator.BeanReflexAssembler;
import top.xiajibagao.crane.core.operator.BeanReflexDisassembler;
import top.xiajibagao.crane.core.operator.BeanReflexOperateProcessor;
import top.xiajibagao.crane.core.operator.interfaces.OperateProcessor;
import top.xiajibagao.crane.core.operator.interfaces.SourceReadInterceptor;
import top.xiajibagao.crane.core.operator.interfaces.SourceReader;
import top.xiajibagao.crane.core.operator.interfaces.TargetWriteInterceptor;
import top.xiajibagao.crane.core.operator.interfaces.TargetWriter;
import top.xiajibagao.crane.core.parser.BeanGlobalConfiguration;
import top.xiajibagao.crane.core.parser.ClassAnnotationConfigurationParser;
import top.xiajibagao.crane.core.parser.CombineOperationConfigurationParser;
import top.xiajibagao.crane.core.parser.FieldAnnotationConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.starter.ConfigHelper;
import top.xiajibagao.crane.starter.CraneAutoConfigurationProperties;

@AutoConfigureAfter(value={CraneAutoConfigurationProperties.class})
@Configuration
public class CraneAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CraneAutoConfiguration.class);

    @Order
    @ConditionalOnMissingBean(value={GlobalConfiguration.class})
    @Bean(value={"CraneDefaultGlobalConfiguration"})
    public GlobalConfiguration globalConfiguration(CraneAutoConfigurationProperties craneAutoConfigurationProperties) {
        return new BeanGlobalConfiguration();
    }

    @Primary
    @Order
    @ConditionalOnMissingBean(value={BeanPropertyFactory.class})
    @Bean(value={"CraneDefaultBeanPropertyFactory"})
    public BeanPropertyFactory beanPropertyFactory(CraneAutoConfigurationProperties craneAutoConfigurationProperties) {
        return craneAutoConfigurationProperties.isEnableAsmReflect() ? new AsmReflexBeanPropertyFactory() : new ReflexBeanPropertyFactory();
    }

    @Order
    @ConditionalOnMissingBean(value={FieldAnnotationConfigurationParser.class})
    @Bean(value={"DefaultCraneFieldAnnotationConfigurationParser"})
    public FieldAnnotationConfigurationParser fieldAnnotationConfigurationParser(GlobalConfiguration configuration, BeanFactory beanFactory) {
        return new FieldAnnotationConfigurationParser(configuration, beanFactory);
    }

    @Order
    @ConditionalOnMissingBean(value={ClassAnnotationConfigurationParser.class})
    @Bean(value={"DefaultCraneClassAnnotationConfigurationParser"})
    public ClassAnnotationConfigurationParser classAnnotationConfigurationParser(GlobalConfiguration configuration, BeanFactory beanFactory) {
        return new ClassAnnotationConfigurationParser(configuration, beanFactory);
    }

    @Primary
    @Order
    @ConditionalOnMissingBean(value={CombineOperationConfigurationParser.class})
    @Bean(value={"DefaultCraneCombineOperationConfigurationParser"})
    public CombineOperationConfigurationParser combineOperationConfigurationParser(Collection<OperateConfigurationParser> parsers) {
        CombineOperationConfigurationParser parser = new CombineOperationConfigurationParser();
        parsers.forEach(arg_0 -> ((CombineOperationConfigurationParser)parser).addParser(arg_0));
        return parser;
    }

    @Order
    @ConditionalOnMissingBean(value={ExpressionPreprocessingInterceptor.ContextFactory.class})
    @Bean(value={"DefaultCraneExpressionPreprocessingInterceptorContextFactory"})
    public ExpressionPreprocessingInterceptor.ContextFactory expressionContextFactory() {
        return new ExpressionPreprocessingInterceptor.DefaultContextFactory();
    }

    @Order
    @ConditionalOnMissingBean(value={ExpressionPreprocessingInterceptor.class})
    @Bean(value={"DefaultCraneExpressionPreprocessingInterceptor"})
    public ExpressionPreprocessingInterceptor expressionPreprocessingInterceptor(ExpressionPreprocessingInterceptor.ContextFactory contextFactory) {
        return new ExpressionPreprocessingInterceptor(contextFactory, new String[0]);
    }

    @ConditionalOnMissingBean(value={NullOperateHandler.class})
    @Bean(value={"DefaultCraneNullOperateHandler"})
    public NullOperateHandler nullOperateHandler(@Qualifier(value="DefaultCraneBeanReflexOperateHandlerChain") OperateProcessor operateProcessor) {
        return new NullOperateHandler(operateProcessor, new String[0]);
    }

    @ConditionalOnMissingBean(value={MapOperateHandler.class})
    @Bean(value={"DefaultCraneMapOperateHandler"})
    public MapOperateHandler mapOperateHandler(@Qualifier(value="DefaultCraneBeanReflexOperateHandlerChain") OperateProcessor operateProcessor) {
        return new MapOperateHandler(operateProcessor, new String[0]);
    }

    @ConditionalOnMissingBean(value={BeanOperateHandler.class})
    @Bean(value={"DefaultCraneBeanOperateHandler"})
    public BeanOperateHandler beanOperateHandler(@Qualifier(value="DefaultCraneBeanReflexOperateHandlerChain") OperateProcessor operateProcessor, BeanPropertyFactory beanPropertyFactory) {
        return new BeanOperateHandler(operateProcessor, beanPropertyFactory, new String[0]);
    }

    @ConditionalOnMissingBean(value={CollectionOperateHandler.class})
    @Bean(value={"DefaultCraneCollectionOperateHandler"})
    public CollectionOperateHandler collectionOperateHandler(@Qualifier(value="DefaultCraneBeanReflexOperateHandlerChain") OperateProcessor operateProcessor) {
        return new CollectionOperateHandler(operateProcessor, new String[0]);
    }

    @ConditionalOnMissingBean(value={ArrayOperateHandler.class})
    @Bean(value={"DefaultCraneArrayOperateHandler"})
    public ArrayOperateHandler arrayOperateHandler(@Qualifier(value="DefaultCraneBeanReflexOperateHandlerChain") OperateProcessor operateProcessor) {
        return new ArrayOperateHandler(operateProcessor);
    }

    @Primary
    @Order
    @ConditionalOnMissingBean(value={BeanReflexOperateProcessor.class})
    @Bean(value={"DefaultCraneBeanReflexOperateHandlerChain"})
    public BeanReflexOperateProcessor beanReflexOperateHandlerChain() {
        return new BeanReflexOperateProcessor();
    }

    @Order
    @ConditionalOnMissingBean(value={BeanReflexAssembler.class})
    @Bean(value={"DefaultCraneBeanReflexAssembler"})
    public BeanReflexAssembler beanReflexAssembler(@Qualifier(value="DefaultCraneBeanReflexOperateHandlerChain") OperateProcessor operateProcessor) {
        return new BeanReflexAssembler(operateProcessor);
    }

    @Order
    @ConditionalOnMissingBean(value={BeanReflexDisassembler.class})
    @Bean(value={"DefaultCraneBeanReflexDisassembler"})
    public BeanReflexDisassembler beanReflexDisassembler(@Qualifier(value="DefaultCraneBeanReflexOperateHandlerChain") OperateProcessor operateProcessor) {
        return new BeanReflexDisassembler(operateProcessor);
    }

    @Primary
    @Order
    @ConditionalOnMissingBean(value={EnumDict.class})
    @Bean(value={"DefaultCraneEnumDict"})
    public EnumDict enumDict() {
        return EnumDict.instance();
    }

    @Order
    @ConditionalOnMissingBean(value={EnumDictContainer.class})
    @Bean(value={"DefaultCraneEnumDictContainer"})
    public EnumDictContainer enumDictContainer(EnumDict enumDict) {
        this.logContainerRegistered(EnumDictContainer.class);
        return new EnumDictContainer(enumDict);
    }

    @Order
    @ConditionalOnMissingBean(value={KeyValueContainer.class})
    @Bean(value={"DefaultCraneKeyValueContainer"})
    public KeyValueContainer simpleKeyValueContainer() {
        this.logContainerRegistered(KeyValueContainer.class);
        return new KeyValueContainer();
    }

    @Order
    @ConditionalOnMissingBean(value={MethodSourceContainer.class})
    @Bean(value={"DefaultCraneMethodSourceContainer"})
    public MethodSourceContainer methodSourceContainer(ApplicationContext applicationContext, BeanPropertyFactory beanPropertyFactory) {
        this.logContainerRegistered(MethodSourceContainer.class);
        MethodSourceContainer container = new MethodSourceContainer(beanPropertyFactory);
        Map beans = applicationContext.getBeansWithAnnotation(MethodSourceBean.class);
        if (CollUtil.isNotEmpty((Map)beans)) {
            beans.forEach((name, bean) -> container.register(bean));
        }
        return container;
    }

    @Order
    @ConditionalOnMissingBean(value={BeanIntrospectContainer.class})
    @Bean(value={"DefaultCraneBeanIntrospectContainer"})
    public BeanIntrospectContainer introspectContainer() {
        this.logContainerRegistered(BeanIntrospectContainer.class);
        return new BeanIntrospectContainer();
    }

    @Order
    @ConditionalOnMissingBean(value={KeyIntrospectContainer.class})
    @Bean(value={"DefaultCraneKeyIntrospectContainer"})
    public KeyIntrospectContainer keyIntrospectContainer() {
        this.logContainerRegistered(KeyIntrospectContainer.class);
        return new KeyIntrospectContainer();
    }

    @Primary
    @Order
    @ConditionalOnMissingBean(value={UnorderedOperationExecutor.class})
    @Bean(value={"DefaultCraneUnorderedOperationExecutor"})
    public UnorderedOperationExecutor unorderedOperationExecutor() {
        return new UnorderedOperationExecutor();
    }

    @Order
    @ConditionalOnMissingBean(value={SequentialOperationExecutor.class})
    @Bean(value={"DefaultCraneSequentialOperationExecutor"})
    public SequentialOperationExecutor operationExecutor() {
        return new SequentialOperationExecutor();
    }

    @Primary
    @Order
    @ConditionalOnMissingBean(value={OperationConfigurationCache.class})
    @Bean(value={"DefaultCraneOperationConfigurationCache"})
    public OperationConfigurationCache operationConfigurationCache() {
        return new OperationConfigurationCache();
    }

    @Order
    @ConditionalOnMissingBean(value={MethodResultProcessAspect.class})
    @Bean(value={"DefaultCraneMethodResultProcessAspect"})
    public MethodResultProcessAspect methodResultProcessAspect(BeanFactory beanFactory, @Qualifier(value="DefaultCraneOperationConfigurationCache") ConfigurationCache configurationCache) {
        log.info("\u542f\u7528\u5207\u9762\uff1a{}", MethodResultProcessAspect.class);
        return new MethodResultProcessAspect(beanFactory, configurationCache);
    }

    @Order
    @ConditionalOnMissingBean(value={OperateTemplate.class})
    @Bean(value={"DefaultCraneOperateTemplate"})
    public OperateTemplate operateTemplate(@Qualifier(value="DefaultCraneOperationConfigurationCache") ConfigurationCache configurationCache, @Qualifier(value="DefaultCraneFieldAnnotationConfigurationParser") OperateConfigurationParser defaultOperateConfigurationParser, @Qualifier(value="DefaultCraneUnorderedOperationExecutor") OperationExecutor defaultOperationExecutor) {
        return new OperateTemplate(configurationCache, defaultOperateConfigurationParser, defaultOperationExecutor);
    }

    private void logContainerRegistered(Class<?> containerClass) {
        log.info("\u6ce8\u518c\u5bb9\u5668\uff1a{}", containerClass);
    }

    @Component
    public static class AfterConfigurationInitedRunner
    implements ApplicationRunner {
        private final BeanReflexOperateProcessor beanReflexOperateProcessor;
        private final Collection<SourceReader> sourceReaders;
        private final Collection<SourceReadInterceptor> sourceReadInterceptors;
        private final Collection<TargetWriteInterceptor> targetWriteInterceptors;
        private final Collection<TargetWriter> targetWriters;
        private final ApplicationContext applicationContext;
        private final CraneAutoConfigurationProperties properties;
        private final ConfigurationCache configurationCache;
        private final EnumDict enumDict;

        public void run(ApplicationArguments args) {
            this.preRegisteredEnum();
            this.preParsedAndCacheClassOperationConfiguration();
            this.initOperateProcessor();
        }

        private void preRegisteredEnum() {
            this.properties.getEnums().getDictEnumPackages().stream().map(ClassUtil::scanPackage).flatMap(Collection::stream).filter(Class::isEnum).map(Class.class::cast).forEach(arg_0 -> ((EnumDict)this.enumDict).register(arg_0));
        }

        private void preParsedAndCacheClassOperationConfiguration() {
            if (!this.properties.getCache().isEnablePreParseClass()) {
                return;
            }
            CraneAutoConfigurationProperties.CacheConfigProperties cacheConfigProperties = this.properties.getCache();
            Map<String, Set<String>> parserAndPreParsedClassPackages = cacheConfigProperties.getParserAndPreParsedClassPackages();
            parserAndPreParsedClassPackages.forEach((parserName, packages) -> {
                OperateConfigurationParser parser = (OperateConfigurationParser)this.applicationContext.getBean(parserName, OperateConfigurationParser.class);
                this.cacheClassOperationConfiguration(parser, (Set<String>)packages);
            });
            Set<String> preParsedClassPackages = cacheConfigProperties.getPreParsedClassPackages();
            OperateConfigurationParser parser = (OperateConfigurationParser)this.applicationContext.getBean(OperateConfigurationParser.class);
            this.cacheClassOperationConfiguration(parser, preParsedClassPackages);
        }

        private void cacheClassOperationConfiguration(OperateConfigurationParser parser, Set<String> packages) {
            String cacheName = parser.getClass().getName();
            packages.stream().map(ClassUtil::scanPackage).flatMap(Collection::stream).distinct().map(arg_0 -> ((OperateConfigurationParser)parser).parse(arg_0)).peek(c -> log.info("\u7f13\u5b58\u9884\u89e3\u6790\u914d\u7f6e[{}]", (Object)c.getTargetClass())).forEach(conf -> this.configurationCache.setConfigurationCache(cacheName, conf.getTargetClass(), conf));
        }

        private void initOperateProcessor() {
            ConfigHelper.registerForOperateProcessor((OperateProcessor)this.beanReflexOperateProcessor, (ListableBeanFactory)this.applicationContext);
        }

        public AfterConfigurationInitedRunner(BeanReflexOperateProcessor beanReflexOperateProcessor, Collection<SourceReader> sourceReaders, Collection<SourceReadInterceptor> sourceReadInterceptors, Collection<TargetWriteInterceptor> targetWriteInterceptors, Collection<TargetWriter> targetWriters, ApplicationContext applicationContext, CraneAutoConfigurationProperties properties, ConfigurationCache configurationCache, EnumDict enumDict) {
            this.beanReflexOperateProcessor = beanReflexOperateProcessor;
            this.sourceReaders = sourceReaders;
            this.sourceReadInterceptors = sourceReadInterceptors;
            this.targetWriteInterceptors = targetWriteInterceptors;
            this.targetWriters = targetWriters;
            this.applicationContext = applicationContext;
            this.properties = properties;
            this.configurationCache = configurationCache;
            this.enumDict = enumDict;
        }
    }
}

