/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import top.xiajibagao.crane.config.CraneGlobalConfiguration;
import top.xiajibagao.crane.container.EnumDictContainer;
import top.xiajibagao.crane.container.KeyValueContainer;
import top.xiajibagao.crane.helper.EnumDict;
import top.xiajibagao.crane.impl.bean.BeanReflexOperatorFactory;
import top.xiajibagao.crane.impl.json.JacksonOperatorFactory;
import top.xiajibagao.crane.impl.json.module.CraneDynamicJsonModule;
import top.xiajibagao.crane.operator.SequentialOperationExecutor;
import top.xiajibagao.crane.operator.UnorderedOperationExecutor;
import top.xiajibagao.crane.parse.BeanOperateConfigurationParser;

public class DefaultCraneConfig {
    @Order
    @ConditionalOnMissingBean(value={BeanOperateConfigurationParser.class})
    @Bean(value={"DefaultCraneBeanOperateConfigurationParser"})
    public BeanOperateConfigurationParser beanOperateConfigurationParser(CraneGlobalConfiguration configuration, BeanFactory beanFactory) {
        return new BeanOperateConfigurationParser(configuration, beanFactory);
    }

    @Order
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    @Bean(value={"DefaultCraneObjectMapper"})
    public ObjectMapper objectMapper(BeanFactory beanFactory) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModule((Module)new CraneDynamicJsonModule(new ObjectMapper(), beanFactory));
        return objectMapper;
    }

    @Order
    @ConditionalOnMissingBean(value={JacksonOperatorFactory.class})
    @Bean(value={"DefaultCraneJacksonOperatorFactory"})
    public JacksonOperatorFactory jacksonOperatorFactory(ObjectMapper objectMapper) {
        return new JacksonOperatorFactory(objectMapper);
    }

    @Order
    @ConditionalOnMissingBean(value={BeanReflexOperatorFactory.class})
    @Bean(value={"DefaultCraneBeanReflexOperatorFactory"})
    public BeanReflexOperatorFactory reflexOperatorFactory() {
        return new BeanReflexOperatorFactory();
    }

    @Order
    @ConditionalOnMissingBean(value={EnumDict.class})
    @Bean(value={"DefaultCraneEnumDict"})
    public EnumDict enumDict() {
        return EnumDict.instance();
    }

    @Order
    @ConditionalOnMissingBean(value={EnumDictContainer.class})
    @Bean(value={"DefaultCraneEnumDictContainer"})
    public EnumDictContainer enumDictContainer(EnumDict enumDict) {
        return new EnumDictContainer(enumDict);
    }

    @Order
    @ConditionalOnMissingBean(value={KeyValueContainer.class})
    @Bean(value={"DefaultCraneKeyValueContainer"})
    public KeyValueContainer simpleKeyValueActuator() {
        return new KeyValueContainer();
    }

    @Order
    @ConditionalOnMissingBean(value={UnorderedOperationExecutor.class})
    @Bean(value={"DefaultCraneUnorderedOperationExecutor"})
    public UnorderedOperationExecutor unorderedOperationExecutor() {
        return new UnorderedOperationExecutor();
    }

    @Order
    @ConditionalOnMissingBean(value={SequentialOperationExecutor.class})
    @Bean(value={"DefaultCraneSequentialOperationExecutor"})
    public SequentialOperationExecutor operationExecutor() {
        return new SequentialOperationExecutor();
    }
}

