/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.container;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import top.xiajibagao.crane.container.Container;
import top.xiajibagao.crane.helper.EnumDict;
import top.xiajibagao.crane.parse.interfaces.AssembleOperation;

public class EnumDictContainer
implements Container {
    private final EnumDict enumDict;

    public <T extends Enum<?>> void register(Class<T> targetClass, String typeName, Function<T, String> itemNameGetter) {
        this.enumDict.register(targetClass, typeName, itemNameGetter);
    }

    public void register(Class<? extends Enum<?>> targetClass) {
        this.enumDict.register(targetClass);
    }

    @Override
    public void process(List<Object> targets, List<AssembleOperation> operations) {
        for (AssembleOperation operation : operations) {
            targets.forEach(target -> {
                Object key = operation.getAssembler().getKey(target, operation);
                if (Objects.isNull(key)) {
                    return;
                }
                EnumDict.EnumDictItem val = this.enumDict.getItem(operation.getNamespace(), key.toString());
                if (Objects.nonNull(val)) {
                    operation.getAssembler().execute(target, val.getBeanMap(), operation);
                }
            });
        }
    }

    public EnumDictContainer(EnumDict enumDict) {
        this.enumDict = enumDict;
    }
}

