/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.container;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.CollectionUtils;
import top.xiajibagao.crane.container.Container;
import top.xiajibagao.crane.helper.TableMap;
import top.xiajibagao.crane.parse.interfaces.AssembleOperation;

public class KeyValueContainer
implements Container {
    public final TableMap<String, String, Object> cache = new TableMap();

    public void register(String namespace, Map<String, ?> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        values.forEach((k, v) -> this.cache.put(namespace, (String)k, v));
    }

    public <T> T get(String namespace, String key) {
        Map container = (Map)this.cache.get(namespace);
        return Objects.isNull(container) ? null : (T)container.get(key);
    }

    @Override
    public void process(List<Object> targets, List<AssembleOperation> operations) {
        if (CollectionUtils.isEmpty(targets) || CollectionUtils.isEmpty(operations)) {
            return;
        }
        targets.forEach(t -> operations.forEach(o -> {
            Object key = o.getAssembler().getKey(t, (AssembleOperation)o);
            if (Objects.isNull(key)) {
                return;
            }
            Object val = this.get(o.getNamespace(), key.toString());
            if (Objects.nonNull(val)) {
                o.getAssembler().execute(t, val, (AssembleOperation)o);
            }
        }));
    }
}

