/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.extend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.xiajibagao.crane.container.Container;
import top.xiajibagao.crane.helper.CollUtils;
import top.xiajibagao.crane.helper.ObjectUtils;
import top.xiajibagao.crane.helper.PairEntry;
import top.xiajibagao.crane.parse.interfaces.AssembleOperation;

public abstract class BaseContainer<K>
implements Container {
    private static final Logger log = LoggerFactory.getLogger(BaseContainer.class);

    @Override
    public void process(List<Object> targets, List<AssembleOperation> operations) {
        if (Objects.isNull(targets) || targets.isEmpty() || CollUtils.isEmpty(operations)) {
            return;
        }
        List<PairEntry<K, String>> keyEnters = this.getKeyEntersFromTargets(targets, operations);
        if (CollUtils.isEmpty(keyEnters)) {
            return;
        }
        Map sources = ObjectUtils.trySupply(() -> this.getSources(keyEnters), e -> log.warn("\u5bb9\u5668[{}]\u83b7\u53d6\u6570\u636e\u6e90\u83b7\u53d6\u5931\u8d25\uff0ckey[{}]\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{this.getClass(), keyEnters, e.getMessage()}));
        if (CollUtils.isEmpty(sources)) {
            return;
        }
        for (Object target : targets) {
            for (AssembleOperation operation : operations) {
                Map keyMap = (Map)sources.get(operation.getNamespace());
                if (CollUtils.isEmpty(keyMap)) {
                    return;
                }
                Object key = operation.getAssembler().getKey(target, operation);
                Object source = keyMap.get(this.parseKey(key));
                if (Objects.isNull(source)) {
                    return;
                }
                ObjectUtils.tryAction(() -> operation.getAssembler().execute(target, source, operation), x -> log.error("\u5b57\u6bb5[{}]\u5904\u7406\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)operation.getTargetProperty(), (Object)x.getMessage()));
            }
        }
    }

    protected abstract Map<String, Map<K, ?>> getSources(List<PairEntry<K, String>> var1);

    protected List<PairEntry<K, String>> getKeyEntersFromTarget(Object target, List<AssembleOperation> operations) {
        ArrayList<PairEntry<K, String>> keyEnters = new ArrayList<PairEntry<K, String>>();
        for (AssembleOperation operation : operations) {
            Object key = operation.getAssembler().getKey(target, operation);
            K actualKey = this.parseKey(key);
            if (!Objects.nonNull(actualKey)) continue;
            keyEnters.add(new PairEntry<K, String>(actualKey, operation.getNamespace()));
        }
        return keyEnters;
    }

    protected List<PairEntry<K, String>> getKeyEntersFromTargets(List<Object> targets, List<AssembleOperation> operations) {
        return targets.stream().filter(Objects::nonNull).map(t -> this.getKeyEntersFromTarget(t, operations)).filter(CollUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected K parseKey(Object key) {
        return (K)key;
    }
}

