/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import top.xiajibagao.crane.helper.CollUtils;
import top.xiajibagao.crane.helper.ObjectUtils;

public class ArrayUtils {
    private ArrayUtils() {
    }

    @SafeVarargs
    public static <T> int getLength(T ... array) {
        return ObjectUtils.computeIfNotNull(array, a -> ((Object[])a).length, 0);
    }

    @SafeVarargs
    public static <T> boolean isEmpty(T ... targets) {
        return Objects.isNull(targets) || targets.length == 0;
    }

    public static boolean notEmpty(Object ... targets) {
        return !ArrayUtils.isEmpty(targets);
    }

    @SafeVarargs
    public static <T> List<T> toList(T ... targets) {
        return ArrayUtils.isEmpty(targets) ? Collections.emptyList() : Arrays.asList(targets);
    }

    public static int size(Object ... targets) {
        return Objects.isNull(targets) ? 0 : targets.length;
    }

    public static <T> T[] merge(Collection<T> coll, T ... appends) {
        Collection appendList = ObjectUtils.computeIfNotNull(appends, Arrays::asList, Collections.emptyList());
        Object[] targets = Stream.of(coll, appendList).filter(CollUtils::isNotEmpty).collect(Collectors.toList()).toArray();
        return ArrayUtils.caseType(new Object[][]{targets});
    }

    private static <T> T[] caseType(Object[] ... targets) {
        return (Object[])targets;
    }
}

