/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.helper;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import top.xiajibagao.crane.helper.ArrayUtils;
import top.xiajibagao.crane.helper.PropertyCache;
import top.xiajibagao.crane.helper.TableMap;

public class BeanPropertyUtils {
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    private static final TableMap<Class<?>, String, PropertyCache> PROPERTY_CACHES = new TableMap();

    private BeanPropertyUtils() {
    }

    public static Optional<PropertyCache> getCache(Class<?> targetClass, String propertyName) {
        Map propertyCaches = PROPERTY_CACHES.computeIfAbsent(targetClass, BeanPropertyUtils::createCache);
        if (CollectionUtils.isEmpty((Map)propertyCaches)) {
            return Optional.empty();
        }
        return Optional.ofNullable(propertyCaches.get(propertyName));
    }

    public static Map<String, PropertyCache> getPropertyCaches(Class<?> targetClass) {
        return PROPERTY_CACHES.computeIfAbsent(targetClass, BeanPropertyUtils::createCache);
    }

    private static Map<String, PropertyCache> createCache(Class<?> targetClass) {
        return Stream.of(targetClass.getDeclaredFields()).map(f -> BeanUtils.getPropertyDescriptor((Class)targetClass, (String)f.getName())).filter(Objects::nonNull).map(d -> new PropertyCache((PropertyDescriptor)d, targetClass)).collect(Collectors.toMap(PropertyCache::getName, Function.identity()));
    }

    public static Method findSetterMethod(Class<?> targetClass, String fieldName, Class<?> fieldType) {
        String methodName = BeanPropertyUtils.getMethodName(SET_PREFIX, fieldName);
        return Stream.of(targetClass.getDeclaredMethods()).filter(m -> Objects.equals(m.getName(), methodName) || Objects.equals(m.getName(), fieldName)).filter(m -> ArrayUtils.getLength(m.getParameterTypes()) == 1 && m.getParameterTypes()[0].isAssignableFrom(fieldType)).findAny().orElse(null);
    }

    public static Method findGetterMethod(Class<?> targetClass, String fieldName) {
        String methodName = BeanPropertyUtils.getMethodName(GET_PREFIX, fieldName);
        return Stream.of(targetClass.getDeclaredMethods()).filter(m -> Objects.equals(m.getName(), methodName) || Objects.equals(m.getName(), fieldName)).filter(m -> ArrayUtils.getLength(m.getParameterTypes()) == 0).findAny().orElse(null);
    }

    private static String getMethodName(String prefix, String key) {
        return prefix + Character.toUpperCase(key.charAt(0)) + key.substring(1);
    }
}

