/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.helper;

import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import top.xiajibagao.crane.annotation.ProcessConfig;
import top.xiajibagao.crane.helper.CollUtils;
import top.xiajibagao.crane.operator.interfaces.OperationExecutor;
import top.xiajibagao.crane.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.parse.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.parse.interfaces.OperationConfiguration;

public abstract class CacheableAnnotationProcessor<T extends AnnotatedElement> {
    private final BeanFactory beanFactory;
    private final Map<String, Processor> processorCache = new ConcurrentHashMap<String, Processor>();

    public void process(T annotatedElement, Object target) {
        ProcessConfig annotation = this.parseAnnotation((AnnotatedElement)annotatedElement);
        if (Objects.isNull(annotation)) {
            return;
        }
        Class<Void> targetClass = annotation.value();
        if (targetClass.isAssignableFrom(Void.TYPE)) {
            return;
        }
        String processorId = this.getProcessorId(annotatedElement, target, annotation);
        Processor processor = this.getProcessor(processorId, annotation);
        this.execute(target, processor);
    }

    protected Processor getProcessor(String processorId, ProcessConfig annotation) {
        return this.processorCache.computeIfAbsent(processorId, id -> {
            OperatorFactory operatorFactory = (OperatorFactory)this.beanFactory.getBean(annotation.operatorFactory());
            OperateConfigurationParser parser = (OperateConfigurationParser)this.beanFactory.getBean(annotation.parser());
            return new Processor((String)id, (OperationExecutor)this.beanFactory.getBean(annotation.executor()), (OperationConfiguration)parser.parse(annotation.value(), operatorFactory));
        });
    }

    protected void execute(Object target, Processor processor) {
        processor.execute(target);
    }

    protected ProcessConfig parseAnnotation(AnnotatedElement annotatedElement) {
        return Objects.isNull(annotatedElement) ? null : (ProcessConfig)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, ProcessConfig.class);
    }

    protected abstract String getProcessorId(T var1, Object var2, ProcessConfig var3);

    public CacheableAnnotationProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public static class SimpleCacheableAnnotationProcessor<T extends AnnotatedElement>
    extends CacheableAnnotationProcessor<T> {
        private final Function<T, String> idMapper;

        public SimpleCacheableAnnotationProcessor(BeanFactory beanFactory, Function<T, String> idMapper) {
            super(beanFactory);
            this.idMapper = idMapper;
        }

        @Override
        protected String getProcessorId(T annotatedElement, Object target, ProcessConfig annotation) {
            return this.idMapper.apply(annotatedElement);
        }
    }

    public static class Processor {
        private final String id;
        private final OperationExecutor executor;
        private final OperationConfiguration configuration;

        public void execute(Object target) {
            this.executor.execute(CollUtils.adaptToCollection(target), this.configuration);
        }

        public String getId() {
            return this.id;
        }

        public OperationExecutor getExecutor() {
            return this.executor;
        }

        public OperationConfiguration getConfiguration() {
            return this.configuration;
        }

        public Processor(String id, OperationExecutor executor, OperationConfiguration configuration) {
            this.id = id;
            this.executor = executor;
            this.configuration = configuration;
        }
    }
}

