/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class CollUtils {
    private CollUtils() {
    }

    public static boolean isEmpty(Map<?, ?> target) {
        return CollectionUtils.isEmpty(target);
    }

    public static boolean isNotEmpty(Map<?, ?> target) {
        return !CollUtils.isEmpty(target);
    }

    public static boolean isEmpty(Collection<?> target) {
        return CollectionUtils.isEmpty(target);
    }

    public static boolean isNotEmpty(Collection<?> target) {
        return !CollUtils.isEmpty(target);
    }

    public static <T> T getFirst(Iterable<T> target) {
        if (Objects.isNull(target)) {
            return null;
        }
        if (target instanceof RandomAccess && target instanceof List) {
            List coll = (List)target;
            return coll.isEmpty() ? null : (T)coll.get(0);
        }
        Iterator<T> iterator = target.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    @NotNull
    public static <T, K, V> Map<K, V> toMap(Collection<T> source, @NotNull Function<T, K> keyMapper, @NotNull Function<T, V> valueMapper) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        return source.stream().filter(Objects::nonNull).filter(t -> Objects.nonNull(keyMapper.apply(t))).filter(t -> Objects.nonNull(valueMapper.apply(t))).collect(Collectors.toMap(keyMapper, valueMapper));
    }

    @NotNull
    public static <T, K> Map<K, T> toMap(Collection<T> source, @NotNull Function<T, K> keyMapper) {
        return CollUtils.toMap(source, keyMapper, Function.identity());
    }

    @NotNull
    public static <A, B, C, D> Map<C, D> toMap(Map<A, B> source, @NotNull Function<A, C> keyMapper, @NotNull Function<B, D> valueMapper, @NotNull Supplier<Map<C, D>> mapFactory) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        Map result = mapFactory.get();
        Objects.requireNonNull(result);
        source.forEach((k, v) -> CollUtils.checkDuplicateAndPut(result, keyMapper.apply(k), valueMapper.apply(v)));
        return result;
    }

    public static <K1, V, K2> Map<K2, V> mapKeys(Map<K1, V> source, Function<K1, K2> keyMapper) {
        return CollUtils.toMap(source, keyMapper, Function.identity(), HashMap::new);
    }

    public static <K, V1, V2> Map<K, V2> mapValues(Map<K, V1> source, Function<V1, V2> valueMapper) {
        return CollUtils.toMap(source, Function.identity(), valueMapper, HashMap::new);
    }

    @NotNull
    public static <T, K, V, C extends Collection<V>> Map<K, C> groupBy(Collection<T> source, @NotNull Function<T, K> keyMapper, @NotNull Function<T, V> valueMapper, @NotNull Supplier<C> collFactory) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        return source.stream().filter(Objects::nonNull).filter(t -> Objects.nonNull(keyMapper.apply(t))).collect(Collectors.groupingBy(keyMapper, HashMap::new, Collectors.mapping(valueMapper, Collectors.toCollection(collFactory))));
    }

    @NotNull
    public static <T, K> Map<K, List<T>> groupBy(Collection<T> source, @NotNull Function<T, K> keyMapper) {
        return CollUtils.groupBy(source, keyMapper, Function.identity(), ArrayList::new);
    }

    @NotNull
    public static <S, K, V, R> Map<K, R> groupByAndThen(Collection<S> source, @NotNull Function<S, K> classify, @NotNull Function<S, V> valueMapper, @NotNull BiFunction<K, List<V>, R> mergeMapper) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        Map<Object, List> first = CollUtils.groupBy(source, classify, valueMapper, ArrayList::new);
        HashMap then = new HashMap(first.size());
        first.forEach((k, v) -> then.put(k, mergeMapper.apply((Object)k, (List)v)));
        return then;
    }

    @NotNull
    public static <S, K, R> Map<K, R> groupByAndThen(Collection<S> source, @NotNull Function<S, K> classify, @NotNull BiFunction<K, List<S>, R> mergeMapper) {
        return CollUtils.groupByAndThen(source, classify, Function.identity(), mergeMapper);
    }

    @NotNull
    public static <S, T, K, R> List<R> groupByThenFlat(List<S> source, @NotNull Function<S, K> classify, @NotNull Function<S, T> mapperAfterClassify, @NotNull BiFunction<K, List<T>, R> flatMapper) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        Map<Object, List> groupByResult = CollUtils.groupByAndThen(source, classify, mapperAfterClassify, (k, l) -> l);
        return CollUtils.toList(groupByResult, flatMapper);
    }

    @NotNull
    public static <S, T, C extends Collection<T>> C toCollection(@NotNull Collection<S> source, @NotNull Supplier<C> collFactory, @NotNull Function<S, T> mapper) {
        return (C)((Collection)source.stream().filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).collect(Collectors.toCollection(collFactory)));
    }

    @NotNull
    public static <S, T, C extends Collection<T>> C toCollection(@NotNull Collection<S> source, @NotNull Supplier<C> collFactory, @NotNull Supplier<T> itemFactory, @NotNull BiConsumer<S, T> itemProcessor) {
        Collection coll = (Collection)collFactory.get();
        Objects.requireNonNull(coll);
        if (source.isEmpty()) {
            return (C)coll;
        }
        for (S s : source) {
            T t = itemFactory.get();
            if (!Objects.nonNull(s)) continue;
            itemProcessor.accept(s, t);
            coll.add(t);
        }
        return (C)coll;
    }

    @NotNull
    public static <K, V, T, C extends Collection<T>> C toCollection(Map<K, V> source, @NotNull Supplier<C> collFactory, @NotNull BiFunction<K, V, T> mapper) {
        if (source == null || source.isEmpty()) {
            Collection result = (Collection)collFactory.get();
            Objects.requireNonNull(result);
            return (C)result;
        }
        return (C)((Collection)source.entrySet().stream().map(e -> mapper.apply(e.getKey(), e.getValue())).filter(Objects::nonNull).collect(Collectors.toCollection(collFactory)));
    }

    @NotNull
    public static <S, T> Set<T> toSet(Collection<S> source, @NotNull Function<S, T> mapper) {
        if (source == null || source.isEmpty()) {
            return Collections.emptySet();
        }
        return CollUtils.toCollection(source, HashSet::new, mapper);
    }

    @NotNull
    public static <T> Set<T> toSet(Collection<T> source) {
        return CollUtils.toSet(source, Function.identity());
    }

    @NotNull
    public static <K, V, T> Set<T> toSet(Map<K, V> source, @NotNull BiFunction<K, V, T> mapper) {
        return CollUtils.toCollection(source, HashSet::new, mapper);
    }

    @NotNull
    public static <K, V, T> List<T> toList(Map<K, V> source, @NotNull BiFunction<K, V, T> mapper) {
        return CollUtils.toCollection(source, ArrayList::new, mapper);
    }

    @NotNull
    public static <S, T> List<T> toList(Collection<S> source, @NotNull Function<S, T> mapper) {
        if (source == null || source.isEmpty()) {
            return Collections.emptyList();
        }
        return CollUtils.toCollection(source, ArrayList::new, mapper);
    }

    @NotNull
    public static <T> List<T> toList(Collection<T> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptyList();
        }
        return CollUtils.toCollection(source, ArrayList::new, Function.identity());
    }

    @NotNull
    public static <S, T> List<T> toList(Collection<S> source, @NotNull Supplier<T> itemFactory, @NotNull BiConsumer<S, T> itemProcessor) {
        return CollUtils.toCollection(source, ArrayList::new, itemFactory, itemProcessor);
    }

    @NotNull
    public static <T> List<T> filter(Collection<T> source, @NotNull Predicate<T> filter) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        return source.stream().filter(Objects::nonNull).filter(filter).collect(Collectors.toList());
    }

    @NotNull
    public static <K, V> Map<K, V> filter(Map<K, V> source, @NotNull BiPredicate<K, V> filter) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        return source.entrySet().stream().filter(e -> Objects.nonNull(e.getKey()) && Objects.nonNull(e.getValue())).filter(e -> filter.test(e.getKey(), e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <T> List<T> filterNotNull(Collection<T> source) {
        return CollUtils.filter(source, Objects::nonNull);
    }

    @NotNull
    public static <K, V> Map<K, V> filterByReverse(Map<K, V> source, @NotNull BiPredicate<K, V> filter) {
        return CollUtils.filter(source, filter.negate());
    }

    @NotNull
    public static <T> List<T> filterByReverse(Collection<T> source, @NotNull Predicate<T> filter) {
        return CollUtils.filter(source, filter.negate());
    }

    @NotNull
    public static <T, R> R reduce(Collection<T> source, @NotNull Function<T, R> mapper, @NotNull R first, @NotNull BinaryOperator<R> accumulator) {
        if (CollectionUtils.isEmpty(source)) {
            return first;
        }
        return (R)source.stream().filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).reduce(first, accumulator);
    }

    public static <T, R> R reduce(Collection<T> source, @NotNull Function<T, R> mapper, @NotNull BinaryOperator<R> accumulator) {
        if (CollectionUtils.isEmpty(source)) {
            return null;
        }
        Object first = null;
        long loopStart = 0L;
        for (T t : source) {
            ++loopStart;
            if (t == null) continue;
            first = t;
            break;
        }
        if (first == null) {
            return null;
        }
        return (R)source.stream().skip(loopStart).filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).reduce(mapper.apply(first), accumulator);
    }

    public static <T> T reduce(Collection<T> source, @NotNull BinaryOperator<T> accumulator) {
        return (T)CollUtils.reduce(source, Function.identity(), accumulator);
    }

    @NotNull
    public static <T> T reduce(Collection<T> source, @NotNull T base, @NotNull BinaryOperator<T> accumulator) {
        return CollUtils.reduce(source, Function.identity(), base, accumulator);
    }

    public static <T, C extends Collection<T>> C foreach(C source, @NotNull Consumer<T> action) {
        if (!CollectionUtils.isEmpty(source)) {
            source.stream().filter(Objects::nonNull).forEach(action);
        }
        return source;
    }

    public static <K, V, M extends Map<K, V>> M foreach(M source, @NotNull BiConsumer<K, V> action) {
        if (!CollectionUtils.isEmpty(source)) {
            source.forEach((k, v) -> {
                if (Objects.nonNull(k) && Objects.nonNull(v)) {
                    action.accept(k, v);
                }
            });
        }
        return source;
    }

    @NotNull
    public static <S, T, C extends Collection<T>> C flatMap(Collection<S> source, @NotNull Function<S, ? extends Collection<T>> mapper, @NotNull Supplier<C> collFactory) {
        if (source == null || source.isEmpty()) {
            Collection result = (Collection)collFactory.get();
            Objects.requireNonNull(result);
            return (C)result;
        }
        return (C)((Collection)source.stream().filter(Objects::nonNull).map(mapper).filter(col -> !CollectionUtils.isEmpty((Collection)col)).flatMap(Collection::stream).collect(Collectors.toCollection(collFactory)));
    }

    @NotNull
    public static <S, T, R extends Collection<T>> List<T> flatMap(Collection<S> source, @NotNull Function<S, R> mapper) {
        return CollUtils.flatMap(source, mapper, ArrayList::new);
    }

    @NotNull
    public static <T> String joining(Collection<T> source, Function<T, ? extends CharSequence> charMapper, CharSequence delimiter, boolean filterBank) {
        if (CollectionUtils.isEmpty(source)) {
            return "";
        }
        if (Objects.isNull(delimiter)) {
            delimiter = "";
        }
        return source.stream().filter(Objects::nonNull).map(charMapper).filter(c -> !filterBank && Objects.nonNull(c) || StringUtils.hasText((CharSequence)c)).collect(Collectors.joining(delimiter));
    }

    @NotNull
    public static <T> String joining(Collection<T> source, Function<T, ? extends CharSequence> charMapper) {
        return CollUtils.joining(source, charMapper, "", true);
    }

    public static Collection<?> adaptToCollection(Object target) {
        if (target instanceof Collection) {
            return (Collection)target;
        }
        if (target instanceof Map) {
            return ((Map)target).values();
        }
        return Collections.singletonList(target);
    }

    @NotNull
    private static <K, V> Map<K, V> checkDuplicateAndPut(@NotNull Map<K, V> source, K key, V value) throws IllegalStateException {
        return CollUtils.checkDuplicateAndPut(source, key, value, k -> new IllegalStateException("\u5b58\u5728\u91cd\u590dkey\uff1a" + key));
    }

    @NotNull
    private static <K, V, E extends Exception> Map<K, V> checkDuplicateAndPut(@NotNull Map<K, V> source, K key, V value, Function<K, E> exceptionFactory) throws E {
        if (source.containsKey(key)) {
            throw (Exception)exceptionFactory.apply(key);
        }
        source.put(key, value);
        return source;
    }
}

