/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.helper;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;

public class ExpressionUtils {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final Map<String, Expression> EXPRESSION_CACHE = new ConcurrentHashMap<String, Expression>();

    private ExpressionUtils() {
    }

    public static ExpressionParser getParser() {
        return PARSER;
    }

    public static Expression parseExp(@NotNull String exp, boolean cached) {
        Expression expression = EXPRESSION_CACHE.get(exp);
        if (Objects.isNull(expression)) {
            expression = PARSER.parseExpression(exp);
            if (cached) {
                EXPRESSION_CACHE.put(exp, expression);
            }
        }
        return expression;
    }

    public static <T> T execute(String exp, Class<T> resultType, boolean cached) {
        return (T)(!StringUtils.hasText((String)exp) ? null : ExpressionUtils.parseExp(exp, cached).getValue(resultType));
    }

    public static <T> T execute(String exp, EvaluationContext context, Class<T> resultType, boolean cached) {
        return (T)(!StringUtils.hasText((String)exp) ? null : ExpressionUtils.parseExp(exp, cached).getValue(context, resultType));
    }

    public static EvaluationContext registerMethodArgs(JoinPoint joinPoint, MethodSignature methodSignature, StandardEvaluationContext context) {
        String[] paramNames = methodSignature.getParameterNames();
        Object[] params = joinPoint.getArgs();
        for (int i = 0; i < params.length; ++i) {
            context.setVariable(paramNames[i], params[i]);
        }
        return context;
    }
}

