/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.helper;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ObjectUtils {
    private ObjectUtils() {
    }

    public static <T> T defaultIfNull(T target, T def) {
        return Objects.isNull(target) ? def : target;
    }

    public static <T, R> R computeIfNotNull(T target, Function<T, R> mapping, R def) {
        return Objects.isNull(target) ? def : ObjectUtils.defaultIfNull(mapping.apply(target), def);
    }

    public static <T, R> R computeIfMatch(T target, Predicate<T> predicate, Function<T, R> mapping, R def) {
        if (Objects.nonNull(target) && predicate.test(target)) {
            R result = mapping.apply(target);
            return ObjectUtils.defaultIfNull(result, def);
        }
        return def;
    }

    public static <T, R> R computeIfMatch(T target, Predicate<T> predicate, Function<T, R> mapping) {
        return ObjectUtils.computeIfMatch(target, predicate, mapping, null);
    }

    public static void tryAction(Runnable runnable, Consumer<Throwable> failAction) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            failAction.accept(e);
        }
    }

    public static <T> T trySupply(Supplier<T> supplier, Consumer<Throwable> failAction) {
        T result = null;
        try {
            result = supplier.get();
        }
        catch (Throwable e) {
            failAction.accept(e);
        }
        return result;
    }

    public static <T> void tryAction(Supplier<T> supplier, Consumer<Throwable> failAction, Consumer<T> successAction) {
        try {
            T result = supplier.get();
            successAction.accept(result);
        }
        catch (Throwable e) {
            failAction.accept(e);
        }
    }
}

