/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.helper;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import top.xiajibagao.crane.exception.CraneException;
import top.xiajibagao.crane.helper.BeanPropertyUtils;
import top.xiajibagao.crane.helper.ObjectUtils;

public class PropertyCache {
    private final PropertyDescriptor descriptor;
    private final Class<?> targetClass;
    private final Method getter;
    private final Method setter;

    public PropertyCache(PropertyDescriptor descriptor, Class<?> targetClass) {
        this.descriptor = descriptor;
        this.targetClass = targetClass;
        this.getter = ObjectUtils.defaultIfNull(descriptor.getReadMethod(), BeanPropertyUtils.findGetterMethod(targetClass, descriptor.getName()));
        Objects.requireNonNull(this.getter, String.format("[%s]\u5c5e\u6027[%s]\u6ca1\u6709getter\u65b9\u6cd5\uff01", targetClass, descriptor.getName()));
        this.setter = ObjectUtils.defaultIfNull(descriptor.getWriteMethod(), BeanPropertyUtils.findSetterMethod(targetClass, descriptor.getName(), descriptor.getPropertyType()));
        Objects.requireNonNull(this.setter, String.format("[%s]\u5c5e\u6027[%s]\u6ca1\u6709setter\u65b9\u6cd5\uff01", targetClass, descriptor.getName()));
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public void setValue(Object target, Object value) {
        CraneException.throwIfFalse(ClassUtils.isAssignable(this.descriptor.getPropertyType(), value.getClass()), "[%s]\u5b57\u6bb5[%s]\u7c7b\u578b\u4e3a[%s]\uff0c\u4f46\u5f85\u6620\u5c04\u7684\u503c[%s]\u7c7b\u578b\u4e3a[%s]", this.targetClass, this.descriptor.getName(), this.descriptor.getPropertyType(), value, value.getClass());
        ReflectionUtils.invokeMethod((Method)this.setter, (Object)target, (Object[])new Object[]{value});
    }

    public Object getValue(Object target) {
        return ReflectionUtils.invokeMethod((Method)this.getter, (Object)target);
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }
}

