/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.helper;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class TableMap<R, C, V>
extends ConcurrentHashMap<R, Map<C, V>>
implements Map<R, Map<C, V>> {
    public V put(R rowKey, C colKey, V val) {
        Map colMap = this.computeIfAbsent(rowKey, rk -> new ConcurrentHashMap(8));
        return colMap.put(colKey, val);
    }

    public TableMap<R, C, V> putAll(TableMap<R, C, V> target) {
        if (Objects.nonNull(target) && !target.isEmpty()) {
            target.forEach(this::put);
        }
        return target;
    }

    public V get(R rowKey, C colKey) {
        Map colMap = (Map)this.get(rowKey);
        return Objects.isNull(colMap) ? null : (V)colMap.get(colKey);
    }
}

