/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.impl.bean;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import top.xiajibagao.crane.exception.CraneException;
import top.xiajibagao.crane.helper.BeanPropertyUtils;
import top.xiajibagao.crane.helper.PropertyCache;
import top.xiajibagao.crane.operator.interfaces.Assembler;
import top.xiajibagao.crane.parse.interfaces.AssembleOperation;
import top.xiajibagao.crane.parse.interfaces.AssembleProperty;

public class BeanReflexAssembler
implements Assembler {
    @Override
    public void execute(Object target, Object source, AssembleOperation operation) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            return;
        }
        this.checkType(target, operation);
        Class<?> targetClass = target.getClass();
        if (CollectionUtils.isEmpty(operation.getProperties())) {
            this.processIfNonProperties(targetClass, target, source, operation);
            return;
        }
        Class<?> sourceClass = source.getClass();
        operation.getProperties().forEach(p -> {
            if (sourceClass.isAssignableFrom(Collection.class)) {
                this.processIfCollectionSource(targetClass, target, (Collection)source, (AssembleProperty)p, operation);
            } else if (sourceClass.isArray()) {
                this.processIfArraySource(targetClass, target, (Object[])source, (AssembleProperty)p, operation);
            } else {
                this.processIfObjectSource(targetClass, target, sourceClass, source, (AssembleProperty)p, operation);
            }
        });
    }

    protected void processIfNonProperties(Class<?> targetClass, Object target, Object source, AssembleOperation operation) {
        BeanPropertyUtils.getCache(targetClass, operation.getTargetProperty().getName()).ifPresent(c -> c.setValue(target, source));
    }

    protected void processIfObjectSource(Class<?> targetClass, Object target, Class<?> sourceClass, Object source, AssembleProperty property, AssembleOperation operation) {
        Optional<PropertyCache> targetProperty = BeanPropertyUtils.getCache(targetClass, property.getReference());
        if (!targetProperty.isPresent()) {
            return;
        }
        if (!StringUtils.hasText((String)property.getResource())) {
            targetProperty.get().setValue(target, source);
            return;
        }
        if (source instanceof Map) {
            Map sourceMap = (Map)source;
            Object val = sourceMap.get(property.getResource());
            if (Objects.nonNull(val)) {
                targetProperty.ifPresent(t -> t.setValue(target, val));
            }
            return;
        }
        BeanPropertyUtils.getCache(sourceClass, property.getResource()).ifPresent(sourceProperty -> ((PropertyCache)targetProperty.get()).setValue(target, sourceProperty.getValue(source)));
    }

    protected void processIfCollectionSource(Class<?> targetClass, Object target, Collection<?> source, AssembleProperty property, AssembleOperation operation) {
        BeanPropertyUtils.getCache(targetClass, property.getReference()).ifPresent(c -> c.setValue(target, source));
    }

    protected void processIfArraySource(Class<?> targetClass, Object target, Object[] source, AssembleProperty property, AssembleOperation operation) {
        BeanPropertyUtils.getCache(targetClass, property.getReference()).ifPresent(c -> c.setValue(target, source));
    }

    @Override
    public Object getKey(Object target, AssembleOperation operation) {
        this.checkType(target, operation);
        return BeanPropertyUtils.getCache(operation.getOwner().getTargetClass(), operation.getTargetProperty().getName()).map(dc -> dc.getValue(target)).orElse(null);
    }

    private void checkType(Object target, AssembleOperation operation) {
        CraneException.throwIfFalse(operation.getOwner().getTargetClass().isAssignableFrom(target.getClass()), "\u64cd\u4f5c\u914d\u7f6e\u7c7b\u578b\u4e3a[%s]\uff0c\u4f46\u5f85\u5904\u7406\u6570\u636e\u7c7b\u578b\u4e3a[%s]", operation.getOwner().getTargetClass(), target.getClass());
    }
}

