/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.impl.bean.aop;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import top.xiajibagao.crane.annotation.ProcessConfig;
import top.xiajibagao.crane.helper.CacheableAnnotationProcessor;
import top.xiajibagao.crane.helper.ExpressionUtils;
import top.xiajibagao.crane.impl.bean.aop.ProcessResult;

@Aspect
public class MethodResultProcessAspect
extends CacheableAnnotationProcessor<Method> {
    private static final Logger log = LoggerFactory.getLogger(MethodResultProcessAspect.class);

    public MethodResultProcessAspect(BeanFactory beanFactory) {
        super(beanFactory);
    }

    @AfterReturning(returning="result", pointcut="@annotation(top.xiajibagao.crane.impl.bean.aop.ProcessResult)")
    public void afterReturning(JoinPoint joinPoint, Object result) {
        if (ObjectUtils.isEmpty((Object)result)) {
            return;
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ProcessResult annotation = (ProcessResult)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ProcessResult.class);
        if (Objects.isNull(annotation)) {
            return;
        }
        String condition = annotation.condition();
        if (!StringUtils.hasText((String)condition)) {
            this.process(method, result);
            return;
        }
        Boolean isProcess = Boolean.TRUE;
        StandardEvaluationContext context = new StandardEvaluationContext();
        ExpressionUtils.registerMethodArgs(joinPoint, methodSignature, context);
        context.setVariable("result", result);
        try {
            isProcess = ExpressionUtils.execute(condition, (EvaluationContext)context, Boolean.class, true);
        }
        catch (Exception e) {
            log.warn("\u8868\u8fbe\u5f0f[{}]\u6267\u884c\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a[{}]", (Object)condition, (Object)e.getMessage());
        }
        if (isProcess.booleanValue()) {
            this.process(method, result);
        }
    }

    @Override
    protected String getProcessorId(Method annotatedElement, Object target, ProcessConfig annotation) {
        return annotatedElement.getName();
    }
}

