/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.impl.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.HashSet;
import java.util.Objects;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import top.xiajibagao.crane.exception.CraneException;
import top.xiajibagao.crane.helper.CollUtils;
import top.xiajibagao.crane.helper.JacksonUtils;
import top.xiajibagao.crane.operator.interfaces.Assembler;
import top.xiajibagao.crane.parse.interfaces.AssembleOperation;
import top.xiajibagao.crane.parse.interfaces.AssembleProperty;

public class JacksonAssembler
implements Assembler {
    protected final ObjectMapper objectMapper;

    @Override
    public void execute(Object target, Object source, AssembleOperation operation) {
        JsonNode sourceNode;
        if (Objects.isNull(source) || !(target instanceof ObjectNode)) {
            return;
        }
        ObjectNode targetNode = (ObjectNode)target;
        JsonNode jsonNode = sourceNode = source instanceof JsonNode ? (JsonNode)source : this.objectMapper.valueToTree(source);
        if (CollectionUtils.isEmpty(operation.getProperties())) {
            this.processIfNonProperties(targetNode, sourceNode, operation);
            return;
        }
        operation.getProperties().forEach(prop -> {
            if (sourceNode.isObject()) {
                this.processPropertyIfObjectSourceNode(targetNode, (ObjectNode)sourceNode, (AssembleProperty)prop, operation);
            } else if (sourceNode.isValueNode()) {
                this.processPropertyIfValueSourceNode(targetNode, (ValueNode)sourceNode, (AssembleProperty)prop, operation);
            } else if (sourceNode.isArray()) {
                this.processPropertyIfArraySourceNode(targetNode, (ArrayNode)sourceNode, (AssembleProperty)prop, operation);
            } else {
                CraneException.throwOf("\u8282\u70b9[%s]\u4e3a\u65e0\u6cd5\u5904\u7406\u7684\u8282\u70b9\u7c7b\u578b:[%s]", sourceNode, sourceNode.getNodeType());
            }
        });
    }

    protected void processIfNonProperties(ObjectNode target, JsonNode source, AssembleOperation operation) {
        HashSet<String> searchNames = new HashSet<String>(operation.getTargetPropertyAliases());
        searchNames.add(this.getTranslatedKeyPropertyName(operation));
        for (String alias : searchNames) {
            target.replace(alias, source);
        }
    }

    protected void processPropertyIfObjectSourceNode(ObjectNode target, ObjectNode source, AssembleProperty property, AssembleOperation operation) {
        String targetProperty = this.translatePropertyName(property.getReference());
        if (StringUtils.hasText((String)property.getResource())) {
            String sourceProperty = this.translatePropertyName(property.getResource());
            target.set(targetProperty, source.get(sourceProperty));
        } else {
            target.set(targetProperty, (JsonNode)source);
        }
    }

    protected void processPropertyIfValueSourceNode(ObjectNode target, ValueNode source, AssembleProperty property, AssembleOperation operation) {
        String targetProperty = this.translatePropertyName(property.getReference());
        target.set(targetProperty, (JsonNode)source);
    }

    protected void processPropertyIfArraySourceNode(ObjectNode target, ArrayNode source, AssembleProperty property, AssembleOperation operation) {
        String targetProperty = this.translatePropertyName(property.getReference());
        target.set(targetProperty, (JsonNode)source);
    }

    @Override
    public Object getKey(Object target, AssembleOperation operation) {
        if (!(target instanceof JsonNode)) {
            return null;
        }
        JsonNode targetNode = (JsonNode)target;
        JsonNode keyProperty = this.findKeyNode(targetNode, operation);
        return Objects.isNull(keyProperty) ? null : keyProperty.asText();
    }

    protected JsonNode findKeyNode(JsonNode target, AssembleOperation operation) {
        String keyPropertyName = this.getTranslatedKeyPropertyName(operation);
        JsonNode keyNode = target.get(keyPropertyName);
        if (JacksonUtils.isNotNull(keyNode)) {
            return keyNode;
        }
        return CollUtils.getFirst(JacksonUtils.findNodes(target, operation.getTargetPropertyAliases()));
    }

    protected String translatePropertyName(String defName) {
        return JacksonUtils.translatePropertyName(this.objectMapper, defName);
    }

    protected String getTranslatedKeyPropertyName(AssembleOperation operation) {
        return this.translatePropertyName(operation.getTargetProperty().getName());
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public JacksonAssembler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

