/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.impl.json.module;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import top.xiajibagao.crane.helper.CacheableAnnotationProcessor;
import top.xiajibagao.crane.impl.json.module.ProcessJson;

public class CraneDynamicJsonModule
extends Module {
    private final CacheableAnnotationProcessor<Class<?>> processor;
    private final ObjectMapper objectMapper;

    public CraneDynamicJsonModule(ObjectMapper objectMapper, CacheableAnnotationProcessor<Class<?>> processor) {
        this.objectMapper = objectMapper;
        this.processor = processor;
    }

    public CraneDynamicJsonModule(ObjectMapper objectMapper, BeanFactory beanFactory) {
        this.objectMapper = objectMapper;
        this.processor = new CacheableAnnotationProcessor.SimpleCacheableAnnotationProcessor<Class>(beanFactory, Class::getName);
    }

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addBeanSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)beanDesc.getBeanClass(), ProcessJson.class) ? new DynamicJsonPropertySerializer(beanDesc.getBeanClass(), CraneDynamicJsonModule.this.objectMapper, CraneDynamicJsonModule.this.processor) : serializer;
            }
        });
    }

    public static class DynamicJsonPropertySerializer<T>
    extends StdSerializer<T> {
        private final ObjectMapper objectMapper;
        private final CacheableAnnotationProcessor<Class<?>> processor;

        public DynamicJsonPropertySerializer(Class<T> t, ObjectMapper objectMapper, CacheableAnnotationProcessor<Class<?>> processor) {
            super(t);
            this.objectMapper = objectMapper;
            this.processor = processor;
        }

        public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                return;
            }
            JsonNode jsonNode = this.objectMapper.valueToTree(value);
            this.processor.process(this.handledType(), jsonNode);
            this.objectMapper.writeTree(gen, jsonNode);
        }
    }
}

