/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.operator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import top.xiajibagao.crane.container.Container;
import top.xiajibagao.crane.helper.CollUtils;
import top.xiajibagao.crane.helper.CounterSet;
import top.xiajibagao.crane.operator.interfaces.OperationExecutor;
import top.xiajibagao.crane.parse.interfaces.AssembleOperation;
import top.xiajibagao.crane.parse.interfaces.DisassembleOperation;
import top.xiajibagao.crane.parse.interfaces.OperationConfiguration;

public class SequentialOperationExecutor
implements OperationExecutor {
    @Override
    public void execute(Iterable<?> targets, OperationConfiguration configuration) {
        if (Objects.isNull(targets) || !targets.iterator().hasNext()) {
            return;
        }
        List<Object> targetsList = StreamSupport.stream(targets.spliterator(), false).collect(Collectors.toList());
        MultiValueMap<OperationConfiguration, Object> collectedConfigurations = this.collectOperationConfigurations(targetsList, configuration, (MultiValueMap<OperationConfiguration, Object>)new LinkedMultiValueMap());
        this.execute(collectedConfigurations);
    }

    protected void execute(MultiValueMap<OperationConfiguration, Object> collectedConfigurations) {
        Set buckets = collectedConfigurations.entrySet().stream().filter(e -> CollUtils.isNotEmpty(((OperationConfiguration)e.getKey()).getAssembleOperations())).map(e -> new Bucket(((OperationConfiguration)e.getKey()).getAssembleOperations(), (List)e.getValue())).peek(b -> Collections.sort(b.getOperations())).collect(Collectors.toSet());
        LinkedMultiValueMap batch = new LinkedMultiValueMap();
        while (CollUtils.isNotEmpty(buckets)) {
            Container maxContainer = (Container)new CounterSet<Object>().plusAll(buckets, Bucket::peekContainerOfFirstOperation).getMax();
            List matchedOperation = buckets.stream().map(b -> b.getOperations(maxContainer)).filter(Bucket::isNotEmpty).collect(Collectors.toList());
            batch.put((Object)maxContainer, matchedOperation);
            buckets = buckets.stream().filter(Bucket::isNotEmpty).collect(Collectors.toSet());
        }
        batch.forEach((container, bucketList) -> container.process(bucketList.stream().map(Bucket::getTargets).flatMap(Collection::stream).collect(Collectors.toList()), bucketList.stream().map(Bucket::getOperations).flatMap(Collection::stream).collect(Collectors.toList())));
    }

    protected MultiValueMap<OperationConfiguration, Object> collectOperationConfigurations(List<Object> targets, OperationConfiguration configuration, MultiValueMap<OperationConfiguration, Object> collectedConfigurations) {
        if (CollectionUtils.isEmpty(targets)) {
            return collectedConfigurations;
        }
        targets.forEach(t -> collectedConfigurations.add((Object)configuration, t));
        List<DisassembleOperation> disassembleOperations = configuration.getDisassembleOperations();
        if (CollectionUtils.isEmpty(disassembleOperations)) {
            return collectedConfigurations;
        }
        for (DisassembleOperation operation : disassembleOperations) {
            List<Object> nestedPropertyValues = targets.stream().map(t -> operation.getDisassembler().execute(t, operation)).flatMap(Collection::stream).collect(Collectors.toList());
            OperationConfiguration operationConfiguration = operation.getTargetOperateConfiguration();
            this.collectOperationConfigurations(nestedPropertyValues, operationConfiguration, collectedConfigurations);
        }
        return collectedConfigurations;
    }

    private static class Bucket {
        private final List<AssembleOperation> operations;
        private final List<Object> targets;

        public Container peekContainerOfFirstOperation() {
            return this.isEmpty() ? null : CollUtils.getFirst(this.operations).getContainer();
        }

        public Bucket getOperations(Container container) {
            AssembleOperation curr;
            ArrayList<AssembleOperation> matched = new ArrayList<AssembleOperation>();
            Iterator<AssembleOperation> iterator = this.operations.iterator();
            while (iterator.hasNext() && Objects.equals((curr = iterator.next()).getContainer(), container)) {
                matched.add(curr);
                iterator.remove();
            }
            return new Bucket(matched, this.targets);
        }

        public boolean isEmpty() {
            return CollectionUtils.isEmpty(this.operations);
        }

        public boolean isNotEmpty() {
            return !this.isEmpty();
        }

        public Bucket(List<AssembleOperation> operations, List<Object> targets) {
            this.operations = operations;
            this.targets = targets;
        }

        public List<AssembleOperation> getOperations() {
            return this.operations;
        }

        public List<Object> getTargets() {
            return this.targets;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bucket)) {
                return false;
            }
            Bucket other = (Bucket)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<AssembleOperation> this$operations = this.getOperations();
            List<AssembleOperation> other$operations = other.getOperations();
            if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
                return false;
            }
            List<Object> this$targets = this.getTargets();
            List<Object> other$targets = other.getTargets();
            return !(this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Bucket;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<AssembleOperation> $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            List<Object> $targets = this.getTargets();
            result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
            return result;
        }

        public String toString() {
            return "SequentialOperationExecutor.Bucket(operations=" + this.getOperations() + ", targets=" + this.getTargets() + ")";
        }
    }
}

