/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.operator;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import top.xiajibagao.crane.container.Container;
import top.xiajibagao.crane.helper.CollUtils;
import top.xiajibagao.crane.helper.PairEntry;
import top.xiajibagao.crane.operator.interfaces.OperationExecutor;
import top.xiajibagao.crane.parse.interfaces.AssembleOperation;
import top.xiajibagao.crane.parse.interfaces.DisassembleOperation;
import top.xiajibagao.crane.parse.interfaces.OperationConfiguration;

public class UnorderedOperationExecutor
implements OperationExecutor {
    @Override
    public void execute(Iterable<?> targets, OperationConfiguration configuration) {
        if (Objects.isNull(targets) || !targets.iterator().hasNext()) {
            return;
        }
        List targetsList = StreamSupport.stream(targets.spliterator(), false).collect(Collectors.toList());
        LinkedMultiValueMap pendingOperations = new LinkedMultiValueMap();
        this.collectOperations(targetsList, configuration, (MultiValueMap<Container, PairEntry<AssembleOperation, ?>>)pendingOperations);
        this.execute((MultiValueMap<Container, PairEntry<AssembleOperation, ?>>)pendingOperations);
    }

    protected void execute(MultiValueMap<Container, PairEntry<AssembleOperation, ?>> pendingOperations) {
        pendingOperations.forEach((container, pairs) -> container.process(CollUtils.toList(pairs, PairEntry::getValue), CollUtils.toList(pairs, PairEntry::getKey)));
    }

    private void collectOperations(Collection<?> targets, OperationConfiguration configuration, MultiValueMap<Container, PairEntry<AssembleOperation, ?>> pendingOperations) {
        if (CollectionUtils.isEmpty(targets)) {
            return;
        }
        this.processAssembleOperations(targets, configuration, pendingOperations);
        this.processDisassembleOperations(targets, configuration, pendingOperations);
    }

    protected void processAssembleOperations(Collection<?> targets, OperationConfiguration configuration, MultiValueMap<Container, PairEntry<AssembleOperation, ?>> pendingProcessors) {
        List<AssembleOperation> operations = configuration.getAssembleOperations();
        if (CollectionUtils.isEmpty(operations)) {
            return;
        }
        operations.forEach(operation -> pendingProcessors.addAll((Object)operation.getContainer(), CollUtils.toList(targets, target -> new PairEntry<AssembleOperation, Object>((AssembleOperation)operation, target))));
    }

    protected void processDisassembleOperations(Collection<?> targets, OperationConfiguration configuration, MultiValueMap<Container, PairEntry<AssembleOperation, ?>> pendingOperations) {
        List<DisassembleOperation> disassembleOperations = configuration.getDisassembleOperations();
        if (CollectionUtils.isEmpty(disassembleOperations)) {
            return;
        }
        for (DisassembleOperation operation : disassembleOperations) {
            Collection nestedPropertyValues = targets.stream().map(t -> operation.getDisassembler().execute(t, operation)).flatMap(Collection::stream).collect(Collectors.toList());
            OperationConfiguration operationConfiguration = operation.getTargetOperateConfiguration();
            this.collectOperations(nestedPropertyValues, operationConfiguration, pendingOperations);
        }
    }
}

