/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.helper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import javax.validation.constraints.NotNull;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.type.UnknownTypeHandler;

public class StatementResultParser<T> {
    private final Configuration configuration;
    private final Class<T> targetClass;
    private TableInfo tableInfo;
    private ResultMap resultMap;

    public static <T> StatementResultParser<T> parse(@NotNull Configuration conf, @NotNull Class<T> targetClass) {
        return new StatementResultParser(conf, targetClass).parse("additional_info_" + targetClass.getName());
    }

    public static <T> StatementResultParser<T> parse(Class<T> targetClass) {
        Configuration conf = (Configuration)SpringUtil.getBean(Configuration.class);
        return new StatementResultParser(conf, targetClass).parse("_DYNAMIC_RESULT_INFO" + targetClass.getName());
    }

    public StatementResultParser<T> parse(String resultMapId) {
        this.parseTableInfo();
        LambdaUtils.installCache((TableInfo)this.tableInfo);
        this.parseResultMap(resultMapId);
        return this;
    }

    private void parseTableInfo() {
        MapperBuilderAssistant assistant = new MapperBuilderAssistant(this.configuration, this.targetClass.getName().replace('.', '/') + ".java (best guess)");
        this.tableInfo = TableInfoHelper.initTableInfo((MapperBuilderAssistant)assistant, (Class)this.targetClass);
    }

    private void parseResultMap(String resultMapId) {
        String id = resultMapId + "_" + this.tableInfo.getEntityType().getName();
        this.resultMap = new ResultMap.Builder(this.tableInfo.getConfiguration(), id, this.tableInfo.getEntityType(), CollUtil.map((Iterable)this.tableInfo.getFieldList(), arg_0 -> this.parseResultMapping(arg_0), (boolean)true)).build();
    }

    private ResultMapping parseResultMapping(TableFieldInfo tableFieldInfo) {
        ResultMapping.Builder builder = new ResultMapping.Builder(this.tableInfo.getConfiguration(), tableFieldInfo.getProperty(), StringUtils.getTargetColumn((String)tableFieldInfo.getColumn()), tableFieldInfo.getPropertyType());
        if (tableFieldInfo.getJdbcType() != null && tableFieldInfo.getJdbcType() != JdbcType.UNDEFINED) {
            builder.jdbcType(tableFieldInfo.getJdbcType());
        }
        TypeHandlerRegistry typeHandlerRegistry = this.tableInfo.getConfiguration().getTypeHandlerRegistry();
        if (tableFieldInfo.getTypeHandler() != null && tableFieldInfo.getTypeHandler() != UnknownTypeHandler.class) {
            TypeHandler typeHandler = typeHandlerRegistry.getMappingTypeHandler(tableFieldInfo.getTypeHandler());
            if (typeHandler == null) {
                typeHandler = typeHandlerRegistry.getInstance(tableFieldInfo.getPropertyType(), tableFieldInfo.getTypeHandler());
            }
            builder.typeHandler(typeHandler);
        }
        return builder.build();
    }

    public StatementResultParser(Configuration configuration, Class<T> targetClass) {
        this.configuration = configuration;
        this.targetClass = targetClass;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public ResultMap getResultMap() {
        return this.resultMap;
    }
}

