/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ClassUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Component;
import top.xiajibagao.mybatis.plus.join.helper.StatementResultParser;
import top.xiajibagao.mybatis.plus.join.wrapper.AbstractDynamicResultWrapper;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
@Component
public class DynamicResultInterceptor
implements Interceptor {
    private static final Map<Configuration, Map<String, MappedStatement>> REDIRECTED_STATEMENT_CACHE = new ConcurrentHashMap();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (!(args[0] instanceof MappedStatement)) {
            return invocation.proceed();
        }
        MappedStatement statement = (MappedStatement)args[0];
        if (!(args[1] instanceof Map)) {
            return invocation.proceed();
        }
        Map params = (Map)args[1];
        if (CollUtil.isNotEmpty((Map)params) && CollUtil.isNotEmpty((Collection)statement.getResultMaps())) {
            this.redirectMappedStatementResult(args, statement, params);
        }
        return invocation.proceed();
    }

    private void redirectMappedStatementResult(Object[] args, MappedStatement originStatement, Map<String, Object> params) {
        Class resultType = ((ResultMap)originStatement.getResultMaps().get(0)).getType();
        if (ClassUtil.isBasicType((Class)resultType)) {
            return;
        }
        params.values().stream().filter(AbstractDynamicResultWrapper.class::isInstance).findFirst().map(AbstractDynamicResultWrapper.class::cast).map(wrapper -> this.convertStatement(originStatement, wrapper.getResultClass())).ifPresent(newStatement -> {
            args[0] = newStatement;
        });
    }

    private MappedStatement convertStatement(MappedStatement originStatement, Class<?> originResultType) {
        String id = originStatement.getId() + "_dynamic_result_" + originResultType.getSimpleName();
        Map mappedCached = REDIRECTED_STATEMENT_CACHE.computeIfAbsent(originStatement.getConfiguration(), config -> new ConcurrentHashMap());
        return mappedCached.computeIfAbsent(id, statementId -> {
            MappedStatement.Builder statementBuilder = new MappedStatement.Builder(originStatement.getConfiguration(), statementId, originStatement.getSqlSource(), originStatement.getSqlCommandType());
            statementBuilder.resource(originStatement.getResource()).fetchSize(originStatement.getFetchSize()).statementType(originStatement.getStatementType()).keyGenerator(originStatement.getKeyGenerator()).timeout(originStatement.getTimeout()).parameterMap(originStatement.getParameterMap()).resultSetType(originStatement.getResultSetType()).cache(originStatement.getCache()).flushCacheRequired(originStatement.isFlushCacheRequired()).useCache(originStatement.isUseCache());
            StatementResultParser parser = StatementResultParser.parse((Configuration)originStatement.getConfiguration(), (Class)originResultType);
            statementBuilder.resultMaps(Collections.singletonList(parser.getResultMap()));
            return statementBuilder.build();
        });
    }
}

