/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.wrapper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import top.xiajibagao.mybatis.plus.join.constants.Condition;
import top.xiajibagao.mybatis.plus.join.helper.ColumnUtils;
import top.xiajibagao.mybatis.plus.join.helper.SqlUtils;
import top.xiajibagao.mybatis.plus.join.wrapper.column.TableColumn;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.ColumnSegment;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.FuncColumnSelect;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.PredicateCompare;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.PredicateFunc;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.TableSegment;

public abstract class AbstractDynamicResultWrapper<T, R, C extends AbstractDynamicResultWrapper<T, R, C>>
extends AbstractWrapper<T, SFunction<T, ?>, C>
implements TableSegment,
PredicateCompare<C, SFunction<T, ?>>,
PredicateFunc<C, SFunction<T, ?>>,
FuncColumnSelect<SFunction<?, ?>, SFunction<T, ?>, SFunction<R, ?>, C> {
    protected String alisa;
    protected TableInfo tableInfo;
    protected Class<T> targetClass;
    protected Class<R> resultClass;
    protected List<ColumnSegment> selectColumns;
    protected boolean isLogic;

    protected AbstractDynamicResultWrapper(@NotNull Class<T> targetClass, @NotNull Class<R> resultClass, boolean isLogic) {
        this.targetClass = targetClass;
        this.resultClass = resultClass;
        this.isLogic = isLogic;
        if (isLogic) {
            this.alisa = "";
        } else {
            this.tableInfo = TableInfoHelper.getTableInfo(targetClass);
            com.baomidou.mybatisplus.core.toolkit.Assert.notNull((Object)this.tableInfo, (String)"\u627e\u4e0d\u5230\u7c7b\u578b[%s]\u5bf9\u5e94\u7684TableInfo\u7f13\u5b58", (Object[])new Object[]{targetClass.getName()});
            this.alisa = this.tableInfo.getTableName();
        }
    }

    protected void initLogicDelete() {
        if (this.isLogic || !this.tableInfo.isWithLogicDelete()) {
            return;
        }
        TableFieldInfo logicDeleteFieldInfo = this.tableInfo.getLogicDeleteFieldInfo();
        String notDeleteValue = this.tableInfo.getLogicDeleteFieldInfo().getLogicDeleteValue();
        this.where((ColumnSegment)new TableColumn((TableSegment)this, logicDeleteFieldInfo.getColumn()), Condition.EQ, (Object)notDeleteValue);
    }

    public C selectAll() {
        this.selectColumns.add(new TableColumn((TableSegment)this, "*"));
        return (C)((AbstractDynamicResultWrapper)this.typedThis);
    }

    public C select(@NotNull ColumnSegment column) {
        this.selectColumns.add(column);
        return (C)((AbstractDynamicResultWrapper)this.typedThis);
    }

    public C where(ColumnSegment column, Condition condition, ISqlSegment valueColumn) {
        return (C)(condition.isHasNextParam() ? (AbstractDynamicResultWrapper)this.doIt(true, new ISqlSegment[]{column, condition, valueColumn}) : (AbstractDynamicResultWrapper)this.doIt(true, new ISqlSegment[]{column, column}));
    }

    public C having(ColumnSegment column, Condition condition, ISqlSegment valueColumn) {
        return (C)((AbstractDynamicResultWrapper)this.doIt(true, new ISqlSegment[]{SqlKeyword.HAVING, column, condition, valueColumn}));
    }

    public C notLikeLeft(Predicate<String> condition, SFunction<T, ?> column, String val) {
        return (C)((AbstractDynamicResultWrapper)this.likeValue(condition.test(val), SqlKeyword.NOT_LIKE, column, (Object)val, SqlLike.LEFT));
    }

    public C notLikeRight(Predicate<String> condition, SFunction<T, ?> column, String val) {
        return (C)((AbstractDynamicResultWrapper)this.likeValue(condition.test(val), SqlKeyword.NOT_LIKE, column, (Object)val, SqlLike.RIGHT));
    }

    public C limit(boolean condition, int limit) {
        this.last(condition, SqlUtils.space((String[])new String[]{"LIMIT", String.valueOf(limit)}));
        return (C)((AbstractDynamicResultWrapper)this.typedThis);
    }

    public C limit(boolean condition, int limit, int offset) {
        this.last(condition, SqlUtils.space((String[])new String[]{"LIMIT", String.valueOf(limit), String.valueOf(offset)}));
        return (C)((AbstractDynamicResultWrapper)this.typedThis);
    }

    public String getTable() {
        Assert.isFalse((boolean)this.isLogic, (String)"\u903b\u8f91\u8868\u6ca1\u6709TableInfo", (Object[])new Object[0]);
        return this.tableInfo.getTableName();
    }

    public ColumnSegment toTableColumn(SFunction<T, ?> column, SFunction<R, ?> alisa) {
        TableColumn tableColumn = new TableColumn((TableSegment)this, this.toStringColumn(column));
        if (Objects.nonNull(alisa)) {
            tableColumn.setAlisa(this.toStringColumn(alisa));
        }
        return tableColumn;
    }

    public String columnToString(SFunction<T, ?> column) {
        Assert.notNull((Object)this.alisa, (String)"\u8868{}\u6ca1\u6709\u8bbe\u7f6e\u522b\u540d\uff01", (Object[])new Object[]{this.getTable()});
        return this.alisa + "." + ColumnUtils.getColumnName(column);
    }

    public String toStringColumn(SFunction<?, ?> column) {
        return ColumnUtils.getColumnName(column);
    }

    protected void initNeed() {
        super.initNeed();
        this.selectColumns = new ArrayList();
    }

    @Nullable
    public String getSqlSelect() {
        return CollUtil.isNotEmpty((Collection)this.selectColumns) ? this.selectColumns.stream().map(ColumnSegment::getColumnSql).collect(Collectors.joining(", ")) : null;
    }

    public C setEntity(T entity) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u4f20\u5165\u5b9e\u4f53");
    }

    public C setEntityClass(Class<T> entityClass) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u4f20\u5165\u5b9e\u4f53");
    }

    public boolean nonEmptyOfEntity() {
        return false;
    }

    public String getAlisa() {
        return this.alisa;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public Class<R> getResultClass() {
        return this.resultClass;
    }

    public List<ColumnSegment> getSelectColumns() {
        return this.selectColumns;
    }

    public boolean isLogic() {
        return this.isLogic;
    }

    public AbstractDynamicResultWrapper() {
    }

    public void setAlisa(String alisa) {
        this.alisa = alisa;
    }
}

