/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.wrapper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import top.xiajibagao.mybatis.plus.join.constants.JoinType;
import top.xiajibagao.mybatis.plus.join.wrapper.AbstractDynamicResultWrapper;
import top.xiajibagao.mybatis.plus.join.wrapper.JoinWrapper;

public class JoinWrapper<T, R>
extends AbstractDynamicResultWrapper<T, R, JoinWrapper<T, R>> {
    protected AtomicInteger joinTableSeq;
    protected List<JoinTable<?, ?, R>> joinTableList;

    public boolean hasJoin() {
        return CollUtil.isNotEmpty((Collection)this.joinTableList);
    }

    public static <T, R> JoinWrapper<T, R> create(@NotNull Class<T> targetClass, @NotNull Class<R> resultClass) {
        JoinWrapper result = new JoinWrapper(targetClass, resultClass, false);
        result.initNeed();
        result.setAlisaByJoinSeq();
        result.initLogicDelete();
        return result;
    }

    protected JoinWrapper(@NotNull Class<T> targetClass, @NotNull Class<R> resultClass, boolean isLogic) {
        super(targetClass, resultClass, isLogic);
    }

    public void setAlisa(String alisa) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("\u65e0\u5141\u8bb8\u81ea\u884c\u8bbe\u7f6e\u522b\u540d");
    }

    protected void setAlisaByJoinSeq() {
        this.alisa = "t" + this.joinTableSeq.incrementAndGet();
    }

    public String getSqlJoin() {
        if (CollUtil.isEmpty((Collection)this.joinTableList)) {
            return "";
        }
        return this.joinTableList.stream().map(JoinTable::getSqlJoin).filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining("\n"));
    }

    public LogicJoinTable<T, R> join(JoinWrapper<?, R> logicTable) {
        return this.addJoin(JoinType.JOIN, logicTable);
    }

    public <J> JoinTable<T, J, R> join(Class<J> joinTable) {
        return this.addJoin(JoinType.JOIN, joinTable);
    }

    public <J> JoinWrapper<T, R> join(Class<J> joinTable, Consumer<JoinTable<T, J, R>> consumer) {
        return this.addJoin(JoinType.JOIN, joinTable, consumer);
    }

    public LogicJoinTable<T, R> innerJoin(JoinWrapper<?, R> logicTable) {
        return this.addJoin(JoinType.INNER_JOIN, logicTable);
    }

    public <J> JoinTable<T, J, R> innerJoin(Class<J> joinTable) {
        return this.addJoin(JoinType.INNER_JOIN, joinTable);
    }

    public <J> JoinWrapper<T, R> innerJoin(Class<J> joinTable, Consumer<JoinTable<T, J, R>> consumer) {
        return this.addJoin(JoinType.INNER_JOIN, joinTable, consumer);
    }

    public LogicJoinTable<T, R> rightJoin(JoinWrapper<?, R> logicTable) {
        return this.addJoin(JoinType.RIGHT_JOIN, logicTable);
    }

    public <J> JoinTable<T, J, R> rightJoin(Class<J> joinTable) {
        return this.addJoin(JoinType.RIGHT_JOIN, joinTable);
    }

    public <J> JoinWrapper<T, R> rightJoin(Class<J> joinTable, Consumer<JoinTable<T, J, R>> consumer) {
        return this.addJoin(JoinType.RIGHT_JOIN, joinTable, consumer);
    }

    public LogicJoinTable<T, R> leftJoin(JoinWrapper<?, R> logicTable) {
        return this.addJoin(JoinType.LEFT_JOIN, logicTable);
    }

    public <J> JoinTable<T, J, R> leftJoin(Class<J> joinTable) {
        return this.addJoin(JoinType.LEFT_JOIN, joinTable);
    }

    public <J> JoinWrapper<T, R> leftJoin(Class<J> joinTable, Consumer<JoinTable<T, J, R>> consumer) {
        return this.addJoin(JoinType.LEFT_JOIN, joinTable, consumer);
    }

    protected LogicJoinTable<T, R> addJoin(JoinType joinType, JoinWrapper<?, R> logicTable) {
        return new LogicJoinTable(joinType, this, logicTable);
    }

    protected <J> JoinTable<T, J, R> addJoin(JoinType joinType, Class<J> joinTable) {
        return new JoinTable(joinType, joinTable, this, false);
    }

    protected <J> JoinWrapper<T, R> addJoin(JoinType joinType, Class<J> joinTable, Consumer<JoinTable<T, J, R>> consumer) {
        JoinTable join = new JoinTable(joinType, joinTable, this, false);
        consumer.accept(join);
        return (JoinWrapper)this.typedThis;
    }

    protected JoinWrapper<T, R> instance() {
        JoinWrapper instance = new JoinWrapper(this.targetClass, this.resultClass, false);
        instance.alisa = this.alisa;
        instance.joinTableSeq = this.joinTableSeq;
        instance.joinTableList = this.joinTableList;
        instance.paramNameSeq = this.paramNameSeq;
        instance.paramNameValuePairs = this.paramNameValuePairs;
        instance.expression = new MergeSegments();
        instance.selectColumns = Collections.emptyList();
        instance.lastSql = this.lastSql;
        instance.sqlComment = this.sqlComment;
        instance.sqlFirst = this.sqlFirst;
        return instance;
    }

    protected void initNeed() {
        super.initNeed();
        this.joinTableSeq = new AtomicInteger(0);
        this.joinTableList = new ArrayList();
    }

    public LogicTable<R> toLogicTable() {
        return new LogicTable(this);
    }

    static /* synthetic */ AtomicInteger access$000(JoinWrapper x0) {
        return x0.paramNameSeq;
    }

    static /* synthetic */ Map access$100(JoinWrapper x0) {
        return x0.paramNameValuePairs;
    }

    static /* synthetic */ MergeSegments access$200(JoinWrapper x0) {
        return x0.expression;
    }

    static /* synthetic */ SharedString access$300(JoinWrapper x0) {
        return x0.lastSql;
    }

    static /* synthetic */ SharedString access$400(JoinWrapper x0) {
        return x0.sqlComment;
    }

    static /* synthetic */ SharedString access$500(JoinWrapper x0) {
        return x0.sqlFirst;
    }
}

