/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.wrapper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import top.xiajibagao.mybatis.plus.join.constants.Condition;
import top.xiajibagao.mybatis.plus.join.constants.JoinType;
import top.xiajibagao.mybatis.plus.join.helper.SqlUtils;
import top.xiajibagao.mybatis.plus.join.wrapper.AbstractDynamicResultWrapper;

public class JoinWrapper<T, R>
extends AbstractDynamicResultWrapper<T, R, JoinWrapper<T, R>> {
    protected AtomicInteger joinTableSeq;
    protected List<JoinTable<?, ?, R>> joinTableList;

    public boolean hasJoin() {
        return CollUtil.isNotEmpty(this.joinTableList);
    }

    public static <T, R> JoinWrapper<T, R> create(@NotNull Class<T> targetClass, @NotNull Class<R> resultClass) {
        JoinWrapper<T, R> result = new JoinWrapper<T, R>(targetClass, resultClass, false);
        result.initNeed();
        result.setAlisaByJoinSeq();
        result.initLogicDelete();
        return result;
    }

    protected JoinWrapper(@NotNull Class<T> targetClass, @NotNull Class<R> resultClass, boolean isLogic) {
        super(targetClass, resultClass, isLogic);
    }

    @Override
    public void setAlisa(String alisa) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("\u65e0\u5141\u8bb8\u81ea\u884c\u8bbe\u7f6e\u522b\u540d");
    }

    protected void setAlisaByJoinSeq() {
        this.alisa = "t" + this.joinTableSeq.incrementAndGet();
    }

    public String getSqlJoin() {
        if (CollUtil.isEmpty(this.joinTableList)) {
            return "";
        }
        return this.joinTableList.stream().map(JoinTable::getSqlJoin).filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining("\n"));
    }

    public LogicJoinTable<T, R> join(JoinWrapper<?, R> logicTable) {
        return this.addJoin(JoinType.JOIN, logicTable);
    }

    public <J> JoinTable<T, J, R> join(Class<J> joinTable) {
        return this.addJoin(JoinType.JOIN, joinTable);
    }

    public <J> JoinWrapper<T, R> join(Class<J> joinTable, Consumer<JoinTable<T, J, R>> consumer) {
        return this.addJoin(JoinType.JOIN, joinTable, consumer);
    }

    public LogicJoinTable<T, R> innerJoin(JoinWrapper<?, R> logicTable) {
        return this.addJoin(JoinType.INNER_JOIN, logicTable);
    }

    public <J> JoinTable<T, J, R> innerJoin(Class<J> joinTable) {
        return this.addJoin(JoinType.INNER_JOIN, joinTable);
    }

    public <J> JoinWrapper<T, R> innerJoin(Class<J> joinTable, Consumer<JoinTable<T, J, R>> consumer) {
        return this.addJoin(JoinType.INNER_JOIN, joinTable, consumer);
    }

    public LogicJoinTable<T, R> rightJoin(JoinWrapper<?, R> logicTable) {
        return this.addJoin(JoinType.RIGHT_JOIN, logicTable);
    }

    public <J> JoinTable<T, J, R> rightJoin(Class<J> joinTable) {
        return this.addJoin(JoinType.RIGHT_JOIN, joinTable);
    }

    public <J> JoinWrapper<T, R> rightJoin(Class<J> joinTable, Consumer<JoinTable<T, J, R>> consumer) {
        return this.addJoin(JoinType.RIGHT_JOIN, joinTable, consumer);
    }

    public LogicJoinTable<T, R> leftJoin(JoinWrapper<?, R> logicTable) {
        return this.addJoin(JoinType.LEFT_JOIN, logicTable);
    }

    public <J> JoinTable<T, J, R> leftJoin(Class<J> joinTable) {
        return this.addJoin(JoinType.LEFT_JOIN, joinTable);
    }

    public <J> JoinWrapper<T, R> leftJoin(Class<J> joinTable, Consumer<JoinTable<T, J, R>> consumer) {
        return this.addJoin(JoinType.LEFT_JOIN, joinTable, consumer);
    }

    protected LogicJoinTable<T, R> addJoin(JoinType joinType, JoinWrapper<?, R> logicTable) {
        return new LogicJoinTable(joinType, this, logicTable);
    }

    protected <J> JoinTable<T, J, R> addJoin(JoinType joinType, Class<J> joinTable) {
        return new JoinTable(joinType, joinTable, this, false);
    }

    protected <J> JoinWrapper<T, R> addJoin(JoinType joinType, Class<J> joinTable, Consumer<JoinTable<T, J, R>> consumer) {
        JoinTable join = new JoinTable(joinType, joinTable, this, false);
        consumer.accept(join);
        return (JoinWrapper)this.typedThis;
    }

    protected JoinWrapper<T, R> instance() {
        JoinWrapper<T, R> instance = new JoinWrapper<T, R>(this.targetClass, this.resultClass, false);
        instance.alisa = this.alisa;
        instance.joinTableSeq = this.joinTableSeq;
        instance.joinTableList = this.joinTableList;
        instance.paramNameSeq = this.paramNameSeq;
        instance.paramNameValuePairs = this.paramNameValuePairs;
        instance.expression = new MergeSegments();
        instance.selectColumns = Collections.emptyList();
        instance.lastSql = this.lastSql;
        instance.sqlComment = this.sqlComment;
        instance.sqlFirst = this.sqlFirst;
        return instance;
    }

    @Override
    protected void initNeed() {
        super.initNeed();
        this.joinTableSeq = new AtomicInteger(0);
        this.joinTableList = new ArrayList();
    }

    public LogicTable<R> toLogicTable() {
        return new LogicTable(this);
    }

    public static class LogicTable<T>
    extends JoinWrapper<T, T> {
        private final JoinWrapper<?, T> table;

        protected LogicTable(JoinWrapper<?, T> logicTable) {
            super(logicTable.getResultClass(), logicTable.getResultClass(), true);
            this.initNeed();
            this.setAlisaByJoinSeq();
            this.table = logicTable;
        }

        @Override
        public String getTable() {
            return SqlUtils.concatBrackets(SqlUtils.wrapperToSql(this.table));
        }
    }

    public static class LogicJoinTable<T, R>
    extends JoinTable<T, R, R> {
        private final JoinWrapper<?, R> logicTable;

        public LogicJoinTable(JoinType joinType, JoinWrapper<T, R> source, JoinWrapper<?, R> logicTable) {
            super(joinType, source.getResultClass(), source, true);
            this.initNeed();
            this.selectColumns = source.selectColumns;
            this.logicTable = logicTable;
        }

        @Override
        public String getTable() {
            return SqlUtils.concatBrackets(SqlUtils.wrapperToSql(this.logicTable));
        }
    }

    public static class JoinTable<T, J, R>
    extends JoinWrapper<J, R> {
        private final JoinType joinType;
        private final JoinWrapper<T, R> source;
        private final MergeSegments joinCondition;

        public JoinTable(JoinType joinType, @NotNull Class<J> targetClass, JoinWrapper<T, R> source, boolean isLogic) {
            super(targetClass, source.getResultClass(), isLogic);
            this.joinType = joinType;
            this.source = source;
            this.joinCondition = new MergeSegments();
            this.joinTableSeq = source.joinTableSeq;
            this.joinTableList = source.joinTableList;
            this.paramNameSeq = ((JoinWrapper)source).paramNameSeq;
            this.paramNameValuePairs = ((JoinWrapper)source).paramNameValuePairs;
            this.expression = ((JoinWrapper)source).expression;
            this.selectColumns = source.selectColumns;
            this.lastSql = ((JoinWrapper)source).lastSql;
            this.sqlComment = ((JoinWrapper)source).sqlComment;
            this.sqlFirst = ((JoinWrapper)source).sqlFirst;
            source.joinTableList.add(this);
            this.setAlisaByJoinSeq();
            this.initLogicDelete();
        }

        public <C> JoinTable<T, J, R> on(SFunction<T, C> sourceColumn, Condition condition, SFunction<J, C> targetColumn) {
            this.joinCondition.add(new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.source.columnToString(sourceColumn), condition, (ISqlSegment & Serializable)() -> this.columnToString(targetColumn)});
            return this;
        }

        @Override
        public String getSqlJoin() {
            if (this.joinCondition.getNormal().isEmpty()) {
                return "";
            }
            return SqlUtils.space(this.joinType.getSqlSegment(), this.getTable(), this.alisa, "ON", this.joinCondition.getSqlSegment());
        }

        public JoinType getJoinType() {
            return this.joinType;
        }

        public JoinWrapper<T, R> getSource() {
            return this.source;
        }

        public MergeSegments getJoinCondition() {
            return this.joinCondition;
        }
    }
}

