/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.wrapper.interfaces;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import java.io.Serializable;
import top.xiajibagao.mybatis.plus.join.constants.FuncKeyword;
import top.xiajibagao.mybatis.plus.join.wrapper.column.ArithmeticColumn;
import top.xiajibagao.mybatis.plus.join.wrapper.column.CaseColumn;
import top.xiajibagao.mybatis.plus.join.wrapper.column.FuncColumn;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.ColumnQuery;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.ColumnSegment;

public interface FuncColumnSelect<P, T extends P, R extends P, C extends FuncColumnSelect<P, T, R, C>>
extends ColumnQuery<P, T, R, C> {
    default public C plus(T left, R alisa, ISqlSegment right) {
        ColumnSegment columnSegment = this.toTableColumn(left, alisa);
        ArithmeticColumn column = ArithmeticColumn.plus(columnSegment, right);
        column.setAlisa(column.getAlisa());
        return this.select(column);
    }

    default public C sub(T left, R alisa, ISqlSegment right) {
        ColumnSegment columnSegment = this.toTableColumn(left, alisa);
        ArithmeticColumn column = ArithmeticColumn.sub(columnSegment, right);
        column.setAlisa(column.getAlisa());
        return this.select(column);
    }

    default public C mul(T left, R alisa, ISqlSegment right) {
        ColumnSegment columnSegment = this.toTableColumn(left, alisa);
        ArithmeticColumn column = ArithmeticColumn.mul(columnSegment, right);
        column.setAlisa(column.getAlisa());
        return this.select(column);
    }

    default public C div(T left, R alisa, ISqlSegment right) {
        ColumnSegment columnSegment = this.toTableColumn(left, alisa);
        ArithmeticColumn column = ArithmeticColumn.div(columnSegment, right);
        column.setAlisa(column.getAlisa());
        return this.select(column);
    }

    default public C now(R alisa) {
        FuncColumn column = new FuncColumn(FuncKeyword.NOW, new ISqlSegment[0]);
        column.setAlisa(this.toStringColumn(alisa));
        return this.select(column);
    }

    default public C currentTimestamp(R alisa) {
        FuncColumn column = new FuncColumn(FuncKeyword.CURRENT_TIMESTAMP, new ISqlSegment[0]);
        column.setAlisa(this.toStringColumn(alisa));
        return this.select(column);
    }

    default public C currentDate(R alisa) {
        FuncColumn column = new FuncColumn(FuncKeyword.CURRENT_DATE, new ISqlSegment[0]);
        column.setAlisa(this.toStringColumn(alisa));
        return this.select(column);
    }

    default public C currentTime(R alisa) {
        FuncColumn column = new FuncColumn(FuncKeyword.CURRENT_TIME, new ISqlSegment[0]);
        column.setAlisa(this.toStringColumn(alisa));
        return this.select(column);
    }

    default public C dateFormat(T column, R alisa, String formatter) {
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.DATE_FORMAT, this.toTableColumn(column, alisa), (ISqlSegment & Serializable)() -> formatter);
        funcColumn.setAlisa(funcColumn.getAlisa());
        return this.select(funcColumn);
    }

    default public C day(T column, R alisa) {
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.DAY, this.toTableColumn(column, alisa));
        funcColumn.setAlisa(funcColumn.getAlisa());
        return this.select(funcColumn);
    }

    default public C month(T column, R alisa) {
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.MONTH, this.toTableColumn(column, alisa));
        funcColumn.setAlisa(funcColumn.getAlisa());
        return this.select(funcColumn);
    }

    default public C year(T column, R alisa) {
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.YEAR, this.toTableColumn(column, alisa));
        funcColumn.setAlisa(funcColumn.getAlisa());
        return this.select(funcColumn);
    }

    default public C abs(T column, R alisa) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.ABS, columnSegment);
        funcColumn.setAlisa(columnSegment.getAlisa());
        return this.select(funcColumn);
    }

    default public C avg(T column, R alisa) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.AVG, columnSegment);
        funcColumn.setAlisa(columnSegment.getAlisa());
        return this.select(funcColumn);
    }

    default public C max(T column, R alisa) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.MAX, columnSegment);
        funcColumn.setAlisa(columnSegment.getAlisa());
        return this.select(funcColumn);
    }

    default public C min(T column, R alisa) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.MIN, columnSegment);
        funcColumn.setAlisa(columnSegment.getAlisa());
        return this.select(funcColumn);
    }

    default public C sum(T column, R alisa) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.SUM, columnSegment);
        funcColumn.setAlisa(columnSegment.getAlisa());
        return this.select(funcColumn);
    }

    default public C rand(R alisa) {
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.RAND, new ISqlSegment[0]);
        funcColumn.setAlisa(this.toStringColumn(alisa));
        return this.select(funcColumn);
    }

    default public C count(T column, R alisa) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.COUNT, columnSegment);
        funcColumn.setAlisa(columnSegment.getAlisa());
        return this.select(funcColumn);
    }

    default public C count(R alisa) {
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.COUNT, (ISqlSegment & Serializable)() -> "*");
        funcColumn.setAlisa(this.toStringColumn(alisa));
        return this.select(funcColumn);
    }

    default public C concat(R alisa, ISqlSegment ... appendValues) {
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.CONCAT, appendValues);
        funcColumn.setAlisa(this.toStringColumn(alisa));
        return this.select(funcColumn);
    }

    default public C format(R alisa, Number number, Integer accuracy) {
        ISqlSegment[] iSqlSegmentArray = new ISqlSegment[2];
        iSqlSegmentArray[0] = number::toString;
        iSqlSegmentArray[1] = accuracy::toString;
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.FORMAT, iSqlSegmentArray);
        funcColumn.setAlisa(this.toStringColumn(alisa));
        return this.select(funcColumn);
    }

    default public C replace(T column, R alisa, String oldStr, String newStr) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.REPLACE, columnSegment, (ISqlSegment & Serializable)() -> oldStr, (ISqlSegment & Serializable)() -> newStr);
        funcColumn.setAlisa(this.toStringColumn(alisa));
        return this.select(funcColumn);
    }

    default public C lower(T column, R alisa) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.LOWER, columnSegment);
        funcColumn.setAlisa(columnSegment.getAlisa());
        return this.select(funcColumn);
    }

    default public C upper(T column, R alisa) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.UPPER, columnSegment);
        funcColumn.setAlisa(columnSegment.getAlisa());
        return this.select(columnSegment);
    }

    default public C ifNull(T column, R alisa, ISqlSegment defaultValue) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.IFNULL, columnSegment, defaultValue);
        funcColumn.setAlisa(columnSegment.getAlisa());
        return this.select(funcColumn);
    }

    default public C ifNull(T column, R alisa, T defaultColumn) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        FuncColumn funcColumn = new FuncColumn(FuncKeyword.IFNULL, columnSegment, this.toTableColumn(defaultColumn, null));
        funcColumn.setAlisa(columnSegment.getAlisa());
        return this.select(funcColumn);
    }

    default public CaseColumn<C> caseByValue(T column, R alisa) {
        ColumnSegment columnSegment = this.toTableColumn(column, alisa);
        CaseColumn<FuncColumnSelect> caseColumn = new CaseColumn<FuncColumnSelect>(true, this, columnSegment);
        caseColumn.setAlisa(columnSegment.getAlisa());
        return caseColumn;
    }

    default public CaseColumn<C> caseByCondition(R alisa) {
        CaseColumn<FuncColumnSelect> caseColumn = new CaseColumn<FuncColumnSelect>(false, this, null);
        caseColumn.setAlisa(this.toStringColumn(alisa));
        return caseColumn;
    }
}

