/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.extend;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public interface ExtendBaseMapper<T>
extends BaseMapper<T> {
    @NotNull
    default public <K> List<T> selectBatchByKeys(Collection<K> keys, @NotNull SFunction<T, K> column) {
        return CollUtil.isEmpty(keys) ? new ArrayList() : this.selectList((Wrapper)this.wrapper().in(column, keys));
    }

    @NotNull
    default public List<T> deleteBatchByIds(Collection<Integer> ids) {
        return CollUtil.isEmpty(ids) ? new ArrayList() : this.deleteBatchByIds(ids);
    }

    @NotNull
    default public <K> List<T> selectSomeColumnsBatchByKeys(Collection<K> keys, @NotNull SFunction<T, K> column, SFunction<T, ?> ... selectColumns) {
        return CollUtil.isEmpty(keys) || ArrayUtil.isEmpty((Object[])selectColumns) ? new ArrayList() : this.selectList((Wrapper)this.wrapper().select(selectColumns).in(column, keys));
    }

    @NotNull
    default public <E, K> List<T> selectBatchByKeys(Collection<E> entities, @NotNull Function<E, K> keyGenerator, @NotNull SFunction<T, K> column) {
        if (entities == null || entities.isEmpty()) {
            return new ArrayList();
        }
        List keys = CollUtil.map(entities, keyGenerator, (boolean)true);
        return keys.isEmpty() ? new ArrayList() : this.selectList((Wrapper)this.wrapper().in(column, (Collection)keys));
    }

    @NotNull
    default public <K> List<T> selectByKey(@NotNull K key, @NotNull SFunction<T, K> column) {
        return this.selectList((Wrapper)this.wrapper().eq(column, key));
    }

    @NotNull
    default public <K> List<T> selectSomeColumnsByKey(@NotNull K key, @NotNull SFunction<T, K> column, SFunction<T, ?> ... selectColumns) {
        return this.selectList((Wrapper)this.wrapper().select(selectColumns).eq(column, key));
    }

    @Nullable
    default public <K> T selectOneByKey(@NotNull K key, @NotNull SFunction<T, K> column) {
        List results = this.selectList((Wrapper)this.wrapper().eq(column, key));
        Assert.isFalse((results.size() > 1 ? 1 : 0) != 0, (String)"\u671f\u671b\u67e5\u8be21\u6570\u636e\uff0c\u4f46\u5b9e\u9645\u8fd4\u56de{}\u6761", (Object[])new Object[]{results.size()});
        return (T)CollUtil.getFirst((Iterable)results);
    }

    @Nullable
    default public <K> T selectOneSomeColumnsByKey(@NotNull K key, @NotNull SFunction<T, K> column, SFunction<T, ?> ... selectColumns) {
        List results = this.selectList((Wrapper)this.wrapper().select(selectColumns).eq(column, key));
        Assert.isFalse((results.size() > 1 ? 1 : 0) != 0, (String)"\u671f\u671b\u67e5\u8be21\u6570\u636e\uff0c\u4f46\u5b9e\u9645\u8fd4\u56de{}\u6761", (Object[])new Object[]{results.size()});
        return (T)CollUtil.getFirst((Iterable)results);
    }

    default public <K> int countByKey(@NotNull K key, @NotNull SFunction<T, K> column) {
        return this.selectCount((Wrapper)this.wrapper().eq(column, key));
    }

    default public LambdaQueryChainWrapper<T> query() {
        return new LambdaQueryChainWrapper((BaseMapper)this);
    }

    default public LambdaUpdateChainWrapper<T> update() {
        return new LambdaUpdateChainWrapper((BaseMapper)this);
    }

    default public LambdaQueryWrapper<T> wrapper() {
        return Wrappers.lambdaQuery();
    }
}

