/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.helper;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import top.xiajibagao.mybatis.plus.join.constants.ExtendConstants;
import top.xiajibagao.mybatis.plus.join.wrapper.JoinWrapper;

public class SqlUtils
implements ExtendConstants {
    public static String space(String ... targets) {
        if (ArrayUtils.isEmpty((Object[])targets)) {
            return "";
        }
        return Stream.of(targets).filter(Objects::nonNull).filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining(" "));
    }

    public static String space(ISqlSegment ... targets) {
        if (ArrayUtils.isEmpty((Object[])targets)) {
            return "";
        }
        return Stream.of(targets).filter(Objects::nonNull).map(ISqlSegment::getSqlSegment).filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining(" "));
    }

    public static String concatAs(@NotNull String columnName, @NotNull String alisaName) {
        return CharSequenceUtil.isNotBlank((CharSequence)alisaName) ? SqlUtils.space(columnName, "AS", alisaName) : columnName;
    }

    public static String concatBrackets(@Nullable String target) {
        return "(" + CharSequenceUtil.emptyIfNull((CharSequence)target) + ")";
    }

    public static String concatSegment(@Nullable String delimiter, @NotNull Collection<? extends ISqlSegment> segments) {
        return segments.stream().map(ISqlSegment::getSqlSegment).collect(Collectors.joining(CharSequenceUtil.nullToEmpty((CharSequence)delimiter)));
    }

    public static String concatSegment(@NotNull Collection<? extends ISqlSegment> segments) {
        return SqlUtils.concatSegment(null, segments);
    }

    public static <W extends JoinWrapper<?, ?>> String wrapperToSql(@NotNull W wrapper) {
        return SqlUtils.space("SELECT", wrapper.getSqlSelect(), "FROM", SqlUtils.space(wrapper.getTable(), wrapper.getAlisa()), "\n", wrapper.getSqlJoin(), "\n", wrapper.getCustomSqlSegment());
    }
}

