/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.wrapper.column;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import top.xiajibagao.mybatis.plus.join.helper.SqlUtils;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.ColumnSegment;

public class ArithmeticColumn
implements ColumnSegment {
    private final ColumnSegment left;
    private final String operator;
    private final ISqlSegment right;

    @Override
    public String getAlisa() {
        return this.left.getAlisa();
    }

    @Override
    public void setAlisa(String alisa) {
        this.left.setAlisa(alisa);
    }

    @Override
    public String getColumn() {
        return SqlUtils.concatBrackets(SqlUtils.space(this.left.getSqlSegment(), this.operator, this.right.getSqlSegment()));
    }

    public String toString() {
        return this.getSqlSegment();
    }

    public static ArithmeticColumn plus(ColumnSegment left, ISqlSegment right) {
        return new ArithmeticColumn(left, "+", right);
    }

    public static ArithmeticColumn sub(ColumnSegment left, ISqlSegment right) {
        return new ArithmeticColumn(left, "-", right);
    }

    public static ArithmeticColumn mul(ColumnSegment left, ISqlSegment right) {
        return new ArithmeticColumn(left, "*", right);
    }

    public static ArithmeticColumn div(ColumnSegment left, ISqlSegment right) {
        return new ArithmeticColumn(left, "/", right);
    }

    public ArithmeticColumn(ColumnSegment left, String operator, ISqlSegment right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public ColumnSegment getLeft() {
        return this.left;
    }

    public String getOperator() {
        return this.operator;
    }

    public ISqlSegment getRight() {
        return this.right;
    }
}

