/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.wrapper.column;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import top.xiajibagao.mybatis.plus.join.constants.Condition;
import top.xiajibagao.mybatis.plus.join.constants.FuncKeyword;
import top.xiajibagao.mybatis.plus.join.helper.SqlUtils;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.ColumnQuery;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.ColumnSegment;

public class CaseColumn<T extends ColumnQuery<?, ?, ?, ?>>
implements ColumnSegment {
    private final boolean onlyMatchingValue;
    private final T result;
    private final List<CaseCondition> whenConditions = new ArrayList<CaseCondition>();
    private CaseCondition elseCondition;
    private final ColumnSegment column;
    private String alisa;

    public CaseColumn<T> when(Object when, Object then) {
        return this.when(when::toString, then::toString);
    }

    public CaseColumn<T> when(ISqlSegment when, ISqlSegment then) {
        this.whenConditions.add(new CaseCondition(FuncKeyword.WHEN, when, then));
        return this;
    }

    public CaseColumn<T> when(ColumnSegment conditionColumn, Condition condition, ISqlSegment conditionValue, ISqlSegment then) {
        this.whenConditions.add(new CaseCondition(FuncKeyword.WHEN, (ISqlSegment & Serializable)() -> SqlUtils.space(new ISqlSegment[]{conditionColumn, condition, condition.isHasNextParam() ? conditionValue : null}), then));
        return this;
    }

    public CaseColumn<T> when(ColumnSegment conditionColumn, Condition condition, Object conditionValue, Object then) {
        return this.when(conditionColumn, condition, conditionValue::toString, then::toString);
    }

    public CaseColumn<T> el(ISqlSegment elseValue) {
        this.elseCondition = new CaseCondition(FuncKeyword.ELSE, (ISqlSegment & Serializable)() -> "", elseValue);
        return this;
    }

    public CaseColumn<T> el(Object elseValue) {
        return Objects.nonNull(elseValue) ? this.el(elseValue::toString) : this;
    }

    public T end() {
        this.result.select((CaseColumn)this);
        return this.result;
    }

    @Override
    public String getColumn() {
        String when = SqlUtils.concatSegment("\n", this.whenConditions);
        String el = Objects.nonNull(this.elseCondition) ? this.elseCondition.getSqlSegment() : "";
        return SqlUtils.concatBrackets(SqlUtils.space(FuncKeyword.CASE.getSqlSegment(), this.onlyMatchingValue ? this.column.getSqlSegment() : null, when, el, FuncKeyword.END.getSqlSegment()));
    }

    public String toString() {
        return this.getSqlSegment();
    }

    public CaseColumn(boolean onlyMatchingValue, T result, ColumnSegment column) {
        this.onlyMatchingValue = onlyMatchingValue;
        this.result = result;
        this.column = column;
    }

    @Override
    public String getAlisa() {
        return this.alisa;
    }

    @Override
    public void setAlisa(String alisa) {
        this.alisa = alisa;
    }

    private static class CaseCondition
    implements ISqlSegment {
        private final FuncKeyword keyword;
        private final ISqlSegment when;
        private final ISqlSegment then;

        public String getSqlSegment() {
            if (FuncKeyword.ELSE.equals((Object)this.keyword)) {
                return SqlUtils.space(this.keyword, this.then);
            }
            return SqlUtils.space(this.keyword, this.when, FuncKeyword.THEN, this.then);
        }

        public FuncKeyword getKeyword() {
            return this.keyword;
        }

        public ISqlSegment getWhen() {
            return this.when;
        }

        public ISqlSegment getThen() {
            return this.then;
        }

        public CaseCondition(FuncKeyword keyword, ISqlSegment when, ISqlSegment then) {
            this.keyword = keyword;
            this.when = when;
            this.then = then;
        }
    }
}

