/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.mybatis.plus.join.wrapper.column;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import top.xiajibagao.mybatis.plus.join.constants.FuncKeyword;
import top.xiajibagao.mybatis.plus.join.helper.SqlUtils;
import top.xiajibagao.mybatis.plus.join.wrapper.interfaces.ColumnSegment;

public class FuncColumn
implements ColumnSegment {
    private final FuncKeyword keyword;
    private final List<ISqlSegment> args;
    private String alisa;

    public FuncColumn(FuncKeyword keyword, ISqlSegment ... args) {
        this(keyword, "", args);
    }

    public FuncColumn(FuncKeyword keyword, String alisa, ISqlSegment ... args) {
        this.keyword = keyword;
        this.alisa = alisa;
        this.args = ArrayUtils.isEmpty((Object[])args) ? Collections.emptyList() : Arrays.asList(args);
    }

    @Override
    public String getColumn() {
        return this.keyword.getSqlSegment() + SqlUtils.concatBrackets(this.getArgsSqlSegment());
    }

    public String getArgsSqlSegment() {
        if (CollUtil.isEmpty(this.args)) {
            return "";
        }
        return this.args.stream().map(ISqlSegment::getSqlSegment).filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining(", "));
    }

    public String toString() {
        return this.getSqlSegment();
    }

    public FuncKeyword getKeyword() {
        return this.keyword;
    }

    public List<ISqlSegment> getArgs() {
        return this.args;
    }

    @Override
    public String getAlisa() {
        return this.alisa;
    }

    @Override
    public void setAlisa(String alisa) {
        this.alisa = alisa;
    }
}

