package com.ben.utils.common

import android.text.format.DateUtils
import com.ben.utils.util.AppUtils
import java.text.ParseException
import java.text.SimpleDateFormat
import java.util.*

/**
 * Author: bin.yang
 * Maintainer: bin.yang
 * Date: 2022/4/26
 * Copyright: 2021 Inc. All rights reserved.
 * Desc:
 */

object DateUtils {
    const val dateFormatChineseYMDHM = "yyyy年MM月dd日 HH:mm"
    const val dateFormatChineseYMD = "yyyy年MM月dd日"

    /**
     * 时间日期格式化到年月日时分秒.
     */
    const val dateFormatLogYMDHMS = "yyyyMMddHHmmss"

    /**
     * 时间日期格式化到年月日时分秒.
     */
    const val dateFormatYMDHMS = "yyyy-MM-dd HH:mm:ss"

    /**
     * 时间日期格式化到年月日.
     */
    const val dateFormatYMD = "yyyy-MM-dd"

    /**
     * 时间日期格式化到年月.
     */
    const val dateFormatYM = "yyyy-MM"

    /**
     * 时间日期格式化到年月日时分.
     */
    const val dateFormatYMDHM = "yyyy-MM-dd HH:mm"

    /**
     * 时间日期格式化到月日.
     */
    const val dateFormatMD = "MM/dd"

    /**
     * 时分秒.
     */
    const val dateFormatHMS = "HH:mm:ss"

    /**
     * 时分.
     */
    const val dateFormatHM = "HH:mm"

    /**
     * 上午.
     */
    const val AM = "AM"

    /**
     * 下午.
     */
    const val PM = "PM"

    /**
     * 获取milliseconds表示的日期时间的字符串.
     *
     * @param milliseconds the milliseconds
     * @param format       格式化字符串，如："yyyy-MM-dd HH:mm:ss"
     * @return String 日期时间字符串
     */
    fun getStringByFormat(milliseconds: Long, format: String?): String? {
        var thisDateTime: String? = null
        try {
            val mSimpleDateFormat = SimpleDateFormat(format)
            thisDateTime = mSimpleDateFormat.format(milliseconds)
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return thisDateTime
    }

    /**
     * 获取milliseconds表示的日期时间的特定格式字符串.
     *
     * @param milliseconds the milliseconds
     * @return String 日期时间字符串，格式为 xxxx年x月x日
     */
    fun getStringByFormat(milliseconds: Long): String? {
        return DateUtils.formatDateTime(
            AppUtils.getApp(),
            milliseconds,
            DateUtils.FORMAT_SHOW_YEAR or DateUtils.FORMAT_SHOW_DATE
        )
    }

    /**
     * 描述：String类型的日期时间转化为Date类型.
     *
     * @param strDate String形式的日期时间
     * @param format  格式化字符串，如："yyyy-MM-dd HH:mm:ss"
     * @return Date Date类型日期时间
     */
    fun getDateByFormat(strDate: String?, format: String?): Date? {
        val mSimpleDateFormat = SimpleDateFormat(format)
        var date: Date? = null
        try {
            date = mSimpleDateFormat.parse(strDate)
        } catch (e: ParseException) {
            e.printStackTrace()
        }
        return date
    }

    /**
     * 获取时间戳
     *
     * @param time
     * @param format
     * @return 时间戳
     */
    fun formatTime(time: String?, format: String?): Long {
        try {
            return getDateByFormat(time, format)!!.time
        } catch (throwable: Throwable) {
            throwable.printStackTrace()
        }
        return -1
    }

    fun getCurrentDateString(): String? {
        return getStringByFormat(System.currentTimeMillis())
    }

    fun getCurrentTimeString(): String? {
        return DateUtils.formatDateTime(
            AppUtils.getApp(),
            System.currentTimeMillis(),
            DateUtils.FORMAT_SHOW_YEAR or DateUtils.FORMAT_SHOW_TIME
        )
    }
}
