package com.ben.utils.common
import android.os.Bundle
import com.ben.utils.log.Logger

/**
 * Author: bin.yang
 * Maintainer: bin.yang
 * Date: 2019/11/21
 * Copyright: 2019 Inc. All rights reserved.
 * Desc:
 */
object DebugUtils {

    private const val TAG = "DebugUtils"

    const val DEBUG = true

    /**
     * 显示bundle里面的参数，用于调试使用
     *
     * @param bundle
     */
    fun showBundleParams(bundle: Bundle) {
        val mIterator = bundle.keySet().iterator()
        while (mIterator.hasNext()) {
            val mNext = mIterator.next()
            val o = bundle.get(mNext)
            o ?: continue
            Logger.d(TAG, "showBundleParams key = $mNext,value = $o,class = ${o.javaClass}")
        }
    }
}
