package com.ben.utils.common

import android.content.Context
import com.ben.utils.util.AppUtils
import com.tencent.mmkv.MMKV

object MMKVUtils {

    private var isInit = false
    private val instance: MMKV by lazy {
        checkInit()
        MMKV.defaultMMKV()
    }

    fun init(context: Context) {
        isInit = true
        MMKV.initialize(context)
    }

    fun isInit(): Boolean {
        return isInit
    }

    fun putString(key: String, value: String?) {
        instance.putString(key, value)
    }

    fun getString(key: String, value: String? = null): String? {
        return instance.getString(key, value)
    }

    fun putLong(key: String, value: Long) {
        instance.putLong(key, value)
    }

    fun getLong(key: String, value: Long = 0): Long {
        return instance.getLong(key, value)
    }

    fun putInt(key: String, value: Int) {
        instance.putInt(key, value)
    }

    fun getInt(key: String, value: Int = 0): Int {
        return instance.getInt(key, value)
    }

    fun putBoolean(key: String, value: Boolean) {
        instance.putBoolean(key, value)
    }

    fun getBoolean(key: String, value: Boolean = false): Boolean {
        return instance.getBoolean(key, value)
    }

    fun putBytes(key: String, bytes: ByteArray) {
        instance.putBytes(key, bytes)
    }

    fun getBytes(key: String, bytes: ByteArray? = null): ByteArray? {
        return instance.getBytes(key, bytes)
    }

    fun putStringSet(key: String, set: Set<String>) {
        instance.putStringSet(key, set)
    }

    fun getStringSet(key: String, set: Set<String>? = null): Set<String>? {
        return instance.getStringSet(key, set)
    }

    private fun checkInit() {
        if (!isInit) init(AppUtils.getApp())
    }
}
