package com.ben.utils.common

import android.annotation.SuppressLint
import android.graphics.Color

/**
 * Author: bin.yang
 * Maintainer: bin.yang
 * Date: 2020/8/24
 * Copyright: 2020 Inc. All rights reserved.
 * Desc:
 */
object ParseUtils {
    @SuppressLint("AvoidUsageApiCheck")
    fun String?.toIntSafety(defaultInt: Int = 0): Int {
        this ?: return defaultInt
        kotlin.runCatching {
            return this.toInt()
        }
        return defaultInt
    }

    fun String?.toColorSafety(defaultColor: Int): Int {
        this ?: return defaultColor
        kotlin.runCatching {
            return Color.parseColor(this)
        }
        return defaultColor
    }
}
