package com.ben.utils.concurrent;

import com.ben.utils.log.Logger;

import java.util.concurrent.ThreadPoolExecutor;

public class AsyncTaskOptimizer {

    private final static String TAG = "AsyncTaskOptimizer";

    /**
     * Optimize the thread pool executor of AsyncTask with {@code allowCoreThreadTimeOut = true}
     */
    static void optimizeAsyncTaskExecutor() {
        try {
            final ThreadPoolExecutor executor = ((ThreadPoolExecutor) android.os.AsyncTask.THREAD_POOL_EXECUTOR);
            executor.allowCoreThreadTimeOut(true);
            Logger.i(TAG, "Optimize AsyncTask executor success！");
        } catch (final Throwable t) {
            Logger.e(TAG, t.toString());
        }
    }
}