package com.ben.utils.concurrent;

import androidx.annotation.NonNull;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class PerfThreadFactory extends AtomicLong implements ThreadFactory {

    private final String mPrefix;
    private final AtomicInteger count = new AtomicInteger(1);

    public PerfThreadFactory(String prefix) {
        mPrefix = prefix;
    }

    @Override
    public Thread newThread(@NonNull final Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName(mPrefix + count.getAndIncrement());
        return thread;
    }
}
