package com.ben.utils.device

/**
 * Created by LiuYang on 2017/3/28.
 */

import android.os.StatFs
import java.text.DecimalFormat

/**
 * @Author: bin.yang
 * @Maintainer: \
 * @Date: 2019/12/20
 * @Copyright: 2019  Inc. All rights reserved.
 * @description: USB工具类
 */
object UsbUtils {

    fun getUsbTotalCapacity(path: String?): String {
        try {
            if (path.isNullOrEmpty()) {
                return ""
            }
            val sf = StatFs(path)
            val blockSize = sf.blockSizeLong
            val blockCount = sf.blockCountLong
            val total = ((blockCount * blockSize).toDouble() / 1024.0 / 1024.0 / 1024.0).toFloat()
            val decimalFormat = DecimalFormat("0.00")
            return decimalFormat.format(total.toDouble()) + "GB"
        } catch (e: Exception) {
            e.printStackTrace()
        }

        return "error"
    }

    fun getUsbUsedCapacity(path: String?): String {
        try {
            if (path.isNullOrEmpty()) {
                return ""
            }
            val sf = StatFs(path)
            val blockSize = sf.blockSizeLong
            val blockCount = sf.blockCountLong
            val availCount = sf.availableBlocksLong
            val total = ((blockCount * blockSize).toDouble() / 1024.0 / 1024.0 / 1024.0).toFloat()
            val avail = ((availCount * blockSize).toDouble() / 1024.0 / 1024.0 / 1024.0).toFloat()
            val decimalFormat = DecimalFormat("0.00")
            return decimalFormat.format((total - avail).toDouble()) + "GB"
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return "error"
    }
}
