package com.ben.utils.event

import android.app.Instrumentation
import android.view.KeyEvent
import java.lang.Exception

/**
 * Author: bin.yang
 * Maintainer: bin.yang
 * Date: 2019/6/29 0029
 * Copyright: 2019 Inc. All rights reserved.
 * Desc:模拟按键相关
 */
object KeyEventUtils {
    /**
     * 发送按键
     *
     * @param action  事件 KeyEvent.ACTION_DOWN KeyEvent.ACTION_UP
     * @param keyCode 键值
     */
    fun sendKeyEvent(action: Int, keyCode: Int) {
        try {
            val inst = Instrumentation()
            inst.sendKeySync(KeyEvent(action, keyCode))
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    /**
     * 发送按键
     *
     * @param keyCode 键值
     */
    fun sendKeyEvent(keyCode: Int) {
        try {
            val inst = Instrumentation()
            inst.sendKeyDownUpSync(keyCode)
        } catch (e: Exception) {
        }
    }
}
