package com.ben.utils.ext

import com.ben.utils.log.Logger

/**
 * Author: bin.yang
 * Maintainer: bin.yang
 * Date: 2022/5/5
 * Copyright: 2021 Inc. All rights reserved.
 * Desc:
 */
inline fun tryCatch(func: () -> Unit) {
    runCatching {
        func()
    }.exceptionOrNull()?.printStackTrace()
}

fun Any.tryCatchForExcIntent(func: () -> Unit) {
    runCatching {
        func()
    }.onFailure {
        it.printStackTrace()
        Logger.e("AutoOpen", "Result = IntentError = ${it.message}\n\n ")
    }
}

inline fun Any.tryCatchWithoutPrint(func: () -> Unit) {
    runCatching {
        func()
    }
}

inline fun Any.tryCatch(func: () -> Unit, noinline error: ((t: Throwable) -> Unit)? = null) {
    runCatching {
        func()
    }.onFailure {
        error?.invoke(it)
        it.printStackTrace()
    }
}

inline fun <T> Any.tryCatchForResult(errorParams: T, func: () -> T): T {
    return runCatching {
        func()
    }.onFailure {
        it.printStackTrace()
    }.getOrNull() ?: errorParams
}

suspend fun Any.trySuspend(func: suspend () -> Unit) {
    runCatching {
        func()
    }.exceptionOrNull()?.printStackTrace()
}
